/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.pa.problem.ProblemNumberFilter;
import com.ibm.hwmca.base.rsf.requests.SdrAdditionalData;
import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.eventmon.email.Emailer;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogClass;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.remsrv.RemoteServiceManager;
import com.ibm.hwmca.p.rsf.PICredentials;
import com.ibm.hwmca.p.sa.CustomerNotifyPersistable;
import com.ibm.hwmca.p.sa.ESAXmitServiceInfoSchedulable;
import com.ibm.hwmca.p.sa.FtpOffLoadPersistable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.XMITServiceInfoPersistable;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.CeComment;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceAgentUtils
implements SdrAdditionalData,
ServiceAgentAttr,
LogClass {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[ServiceAgentUtils] ";
    public static final int ESA_RSF_SERVICE_SERVER = 1;
    public static final int ESA_RSF_NOSERVICE_SERVER = 2;
    public static final int ESA_RSF_SERVICE_NOSERVER = 3;
    public static final int ESA_RSF_NOSERVICE_NOSERVER = 4;
    public static final int ESA_RSF_NOT_SUPPORTED = 5;
    public static final String hmcTypeFile = "/opt/hsc/data/hmcType.properties";
    public static final String ESAMSG = "com.ibm.hwmca.p.sa.res.SaMessages";
    public static final int ESA_SYNC = 1;
    public static final int ESA_ASYNC = 2;
    private static final String ESA_PATH = "esadirectory";
    private static final String ESA_PMH_DEFAULT = "NOPMH";
    private static final String ESA_PROB_DEFAULT = "NOPROB";
    public static final String ESA_KEY_PRIMARYID = "-PrimaryID";
    public static final String ESA_KEY_OPTIONALID = "-OptionalID";
    public static final String ESA_KEY_SENDINGMACHINEID = "-SendingMachineID";
    public static final String ESA_KEY_SENDINGPASSWORD = "-SendingPassword";
    public static final String ESA_KEY_OWNINGMACHINEID = "-OwningMachineID";
    public static final String ESA_KEY_OWNINGPASSWORD = "-OwningPassword";
    public static final String ESA_KEY_SENDINGCLIENTVERSION = "-SendingClientVersion";
    public static final String ESA_KEY_OWNINGCLIENTVERSION = "-OwningClientVersion";
    public static final String ESA_KEY_EED_FILENAME = "-FileName";
    public static final String ESA_KEY_EED_TIMESTAMP = "-TimeStamp";
    public static final String ESA_KEY_EED_LENGTH = "-Length";
    public static final String ESA_KEY_HCHK_REPORTING_SYSTEM = "-ReportingSystem";
    public static final String ESA_KEY_HCHK_FREQUENCY = "-Frequency";
    public static final String ESA_KEY_HCHK_STATUS = "-Status";
    public static final String ESA_KEY_VPD_NONDELTAREASON = "-NonDeltaReason";
    public static final String ESA_KEY_AIXPM_DATATYPE = "-DataType";
    public static final String AIXPM_DATATYPE_DISKUSAGESTAT = "1";
    public static final String AIXPM_DATATYPE_IOSTAT = "2";
    public static final String AIXPM_DATATYPE_NETWORKSTAT = "3";
    public static final String AIXPM_DATATYPE_STATS = "4";
    public static final String AIXPM_DATATYPE_ENVIRONMENTSTAT = "5";
    public static final String SAAIXPM_DATATYPE_DISKUSAGESTAT = "-d";
    public static final String SAAIXPM_DATATYPE_IOSTAT = "-i";
    public static final String SAAIXPM_DATATYPE_NETWORKSTAT = "-n";
    public static final String SAAIXPM_DATATYPE_STATS = "-s";
    public static final String SAAIXPM_DATATYPE_ENVIRONMENTSTAT = "-e";
    public static final String RUNPMAIX_rmcRC = "rmcRC";
    public static final String RUNPMAIX_pmRC = "pmRC";
    public static final String RUNPMAIX_pmPath = "pmPath";
    public static final String RUNPMAIX_pmErrorMsg = "pmErrorMsg";
    public static final String AIXPM_OUTPUT_DIRECTORY = "/var/adm/perfmgr/";
    public static final String AIXPM_DISKUSAGESTAT = "dustat.send";
    public static final String AIXPM_ENVIRONMENTSTAT = "envstat.send";
    public static final String AIXPM_IOSTAT = "iostat.send";
    public static final String AIXPM_NETWORKSTAT = "netstat.send";
    public static final String AIXPM_STATS = "stats.send";
    public static final int ESA_SDR_AUTHORIZE1 = 1;
    private static final String ESA_SDR_AUTHORIZE1_FILE = "ESAAuthorize1.xml";
    public static final int ESA_SDR_AUTHORIZE2 = 2;
    private static final String ESA_SDR_AUTHORIZE2_FILE = "ESAAuthorize2.xml";
    public static final int ESA_SDR_PROBLEMEED = 3;
    public static final int ESA_SDR_DUMPEED = 4;
    public static final int ESA_SDR_ENDOFCALLEED = 5;
    private static final String ESA_SDR_EED_FILE = "ESAEED.xml";
    public static final int ESA_SDR_FULLVPD = 6;
    private static final String ESA_SDR_FULLVPD_FILE = "ESAFullVPD.xml";
    public static final int ESA_SDR_HEALTHCHECK = 7;
    private static final String ESA_SDR_HEALTHCHECK_FILE = "ESAHealthCheck.xml";
    public static final int ESA_SDR_PMDATA = 8;
    private static final String ESA_SDR_PMDATA_FILE = "ESAPMData.xml";
    public static final String ESA_PR_VAL_SUCCESS = "ESA.status.success";
    public static final String ESA_PR_VAL_PENDING = "ESA.status.pending";
    public static final String ESA_PR_VAL_FAILED = "ESA.status.failed";
    public static final String ESA_PR_VAL_PMRSTATUS_OPEN = "ESA.pmrstatus.open";
    public static final String ESA_PR_VAL_PMRSTATUS_CE = "ESA.pmrstatus.ce";
    public static final String ESA_PR_VAL_PMRSTATUS_FIX = "ESA.pmrstatus.fix";
    public static final String ESA_CUSTOMER_NOTIFY_PERSIST = "com.ibm.hwmca.p.sa.persist.CustomerNotify";
    public static final String F_ESA_CUSTOMER_NOTIFY_PERSIST = "com/ibm/hwmca/p/sa/persist/CustomerNotify";
    public static final String ESA_FTP_OFFLOAD_PERSIST = "com.ibm.hwmca.p.sa.persist.FtpOffLoad";
    public static final String F_ESA_FTP_OFFLOAD_PERSIST = "com/ibm/hwmca/p/sa/persist/FtpOffLoad";
    public static final String ESA_XMIT_SERVICE_INFO_PERSIST = "com.ibm.hwmca.p.sa.persist.XmitServiceInfo";
    public static final String F_ESA_XMIT_SERVICE_INFO_PERSIST = "com/ibm/hwmca/p/sa/persist/XmitServiceInfo";
    public static final String ESA_ALL = "ESA.All";
    public static final String ESA_CALLHOMEONLY = "ESA.CallHomeOnly";
    public static final int ESA_EMAILADDRESS_ALREADY_EXISTS = 1;
    public static final int ESA_EMAILADDRESS_NOT_FOUND = 2;
    public static final int ESA_EMAIL_SEND_ERROR = 3;
    public static final int ESA_CNP_WRITE_EXCEPTION = 1;
    public static final int ESA_CNP_WRITE_NOT_SET = 2;
    public static final int ESA_CNP_READ_NOT_SET = 3;
    public static final int ESA_XMIT_WRITE_EXCEPTION = 4;
    public static final int ESA_XMIT_WRITE_NOT_SET = 5;
    public static final int ESA_XMIT_READ_NOT_SET = 6;
    public static final int ESA_FTP_WRITE_EXCEPTION = 7;
    public static final int ESA_FTP_WRITE_NOT_SET = 8;
    public static final int ESA_FTP_READ_NOT_SET = 9;
    public static final int ESA_FTP_FW_WRITE_EXCEPTION = 10;
    public static final int ESA_FTP_FW_WRITE_NOT_SET = 11;
    public static final int ESA_FTP_FW_READ_NOT_SET = 12;
    private static final String ESA_FTP_FIREWALL_FILE = "firewall";
    private static final String ESA_FTP_FIREWALL_SAVE_FILE = "/root/.ncftp/firewall";
    public static final String ESA_KEY_FtpFirewallType = "-FtpFirewallType";
    public static final String ESA_KEY_FtpFirewallHostName = "-FtpFirewallHostName";
    public static final String ESA_KEY_FtpFirewallUserName = "-FtpFirewallUserName";
    public static final String ESA_KEY_FtpFirewallUserPassword = "-FtpFirewallUserPassword";
    public static final String ESA_KEY_FtpFirewallPort = "-FtpFirewallPort";
    public static final String ESA_KEY_FtpFirewallExclusionList = "-FtpFirewallExclusionList";
    public static final String ESA_KEY_FtpFirewallPassiveMode = "-FtpFirewallPassiveMode";
    private static final String DFC_OEM_PROBLEM_DIR = "oemproblemdir";
    private static final String IBM_SERVICE_FILE = "/opt/hsc/data/ibmserviced.dat";
    private static final String OEM_PROBLEM_PROGRAM = "/opt/hsc/bin/callsa";
    private static String OEMProblemDir = null;
    private static final String startDelim = "<==>";
    private static final String delim = ";";
    private static final char delimChar = ';';
    private static final String endDelim = "<=;=>";
    private static final String TIMESTAMP_PATTERN = "MM/dd/yyyy HH:mm:ss";
    static final Comparator PRIORITY_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] -> PRIORITY_ORDER");
            int cmp = 0;
            sectionInfo si1 = (sectionInfo)o1;
            sectionInfo si2 = (sectionInfo)o2;
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si1.priority: " + si1.priority + " si1.size: " + si1.size);
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si2.priority: " + si2.priority + " si2.size: " + si2.size);
            cmp = si1.priority == si2.priority ? 1 : si1.priority - si2.priority;
            return cmp;
        }
    };
    static final Comparator SECTION_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] -> SECTION_ORDER");
            int cmp = 0;
            sectionInfo si1 = (sectionInfo)o1;
            sectionInfo si2 = (sectionInfo)o2;
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si1.section: " + si1.section);
            Trace.trace(ServiceAgentUtils.TRACE_MASKF, "[ServiceAgentUtils] si2.section: " + si2.section);
            cmp = si1.section <= si2.section ? -1 : 1;
            return cmp;
        }
    };

    public String updateConnectionInfo(String xmlRequest, File dataFile, String sendingMachineId, String sendingPassword, String owningMachineId, String owningPassword, String connectionType, String acctName, String acctUserid) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateConnectionInfo");
        String result = xmlRequest;
        Pattern p = Pattern.compile(ESA_KEY_SENDINGMACHINEID);
        Matcher m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(sendingMachineId);
        p = Pattern.compile(ESA_KEY_SENDINGPASSWORD);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(sendingPassword);
        p = Pattern.compile(ESA_KEY_OWNINGMACHINEID);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(owningMachineId);
        p = Pattern.compile(ESA_KEY_OWNINGPASSWORD);
        m = p.matcher("");
        m.reset(result);
        result = m.replaceAll(owningPassword);
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updated xml[" + result + "]");
        return result;
    }

    public String extractXmlRc(String xmlResponse) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] extractXmlRc");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResponse[" + xmlResponse + "]");
        String XmlRc = "0000";
        HashMap map = new HashMap();
        ServiceAgentUtils.processSdrReturn(xmlResponse, map);
        String return_code = (String)map.get("return-code");
        if (return_code != null) {
            XmlRc = return_code;
        }
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] extractXmlRc: " + XmlRc);
        return XmlRc;
    }

    public static void processSdrReturn(String xmlResponse, Map map) {
        try {
            byte[] xml = xmlResponse.getBytes("US-ASCII");
            Document returnXml = new HwmcaParser(xml, false).getDocument();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] done parsing xmlResponse");
            if (returnXml != null) {
                Element root = returnXml.getDocumentElement();
                if (root.getNodeName().toLowerCase().trim().equals("sessionless-sdr-return-v2")) {
                    NamedNodeMap nnm = root.getAttributes();
                    if (nnm != null) {
                        for (int i = 0; i < nnm.getLength(); ++i) {
                            Node val = nnm.item(i);
                            map.put(val.getNodeName().toLowerCase().trim(), val.getNodeValue());
                            Trace.trace(TRACE_MASKF, CLASS_NAME + val.getNodeName().toLowerCase().trim() + " " + val.getNodeValue());
                        }
                    }
                    NodeList childNodes = root.getChildNodes();
                    int numChildren = childNodes.getLength();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got " + numChildren + " children to process");
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = childNodes.item(i);
                        if (child.getNodeType() == 1) {
                            Node text;
                            NodeList textnodes;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got ELEMENT_NODE " + child.getNodeName().toLowerCase().trim());
                            if (child.getNodeName().toLowerCase().trim().equals("reason-qualifier")) {
                                textnodes = child.getChildNodes();
                                if (textnodes == null) continue;
                                text = textnodes.item(0);
                                map.put(child.getNodeName().toLowerCase().trim(), text.getNodeValue());
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sdr-return: " + child.getNodeName().toLowerCase().trim() + " " + text.getNodeValue());
                                continue;
                            }
                            if (child.getNodeName().toLowerCase().trim().equals("return-text")) {
                                textnodes = child.getChildNodes();
                                if (textnodes == null) continue;
                                text = textnodes.item(0);
                                map.put(child.getNodeName().toLowerCase().trim(), text.getNodeValue());
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sdr-return: " + child.getNodeName().toLowerCase().trim() + " " + text.getNodeValue());
                                continue;
                            }
                            if (child.getNodeName().toLowerCase().trim().equals("pmr") || child.getNodeName().toLowerCase().trim().equals("download-menu") || child.getNodeName().toLowerCase().trim().equals("download-item") || child.getNodeName().toLowerCase().trim().equals("generic-data") || child.getNodeName().toLowerCase().trim().equals("processing-parm") || child.getNodeName().toLowerCase().trim().equals("enrollment-output") || child.getNodeName().toLowerCase().trim().equals("microcode-download-file") || child.getNodeName().toLowerCase().trim().equals("microcode-customized-list") || child.getNodeName().toLowerCase().trim().equals("microcode-master-list")) continue;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] unknown ELEMENT_NODE: " + child.getNodeName().toLowerCase().trim());
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got a non-element node" + child.getNodeName());
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] element not sessionless-sdr-return-v2: " + root.getNodeName());
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception e " + e);
        }
    }

    public static int ESACheckRSF() {
        RemoteSupportFacility rsfImpl;
        int rsfSetting = 5;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESACheckRSF");
        rsfSetting = ServiceAgentUtils.isOEM() ? 1 : ((rsfImpl = RsfManager.getRsfManager().getConsoleRsf()) != null ? (rsfImpl.isCallHomeEnabled() && rsfImpl.isCallHomeServerAvailable() ? 1 : (!rsfImpl.isCallHomeEnabled() && rsfImpl.isCallHomeServerAvailable() ? 2 : (rsfImpl.isCallHomeEnabled() && !rsfImpl.isCallHomeServerAvailable() ? 3 : 4))) : 5);
        return rsfSetting;
    }

    public static boolean ESACheckRSF(String machType, String machModel, String machSerial) {
        boolean rsfSetting = false;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESACheckRSF");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machType: " + machType);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machModel: " + machModel);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machSerial: " + machSerial);
        if (ServiceAgentUtils.isOEM()) {
            rsfSetting = true;
        } else {
            RemoteSupportFacility rsfImpl = RsfManager.getRsfManager().getConsoleRsf();
            if (rsfImpl != null) {
                RemoteServiceManager rsm = RemoteServiceManager.getRemoteServiceManager();
                if (rsm != null) {
                    boolean setting = rsm.isRemoteServiceEnabled(machType, machModel, machSerial);
                    if (setting && rsfImpl.isCallHomeServerAvailable()) {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] service is enabled");
                        rsfSetting = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] isRemoteServiceEnabled: " + setting);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] isCallHomeServerAvailable: " + setting);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rsm was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rsfImpl was null");
            }
        }
        return rsfSetting;
    }

    private static String ESAProcessXMLRequest(int requestType, Map xmlMap) {
        String XMLfile = "";
        String xmlResults = "";
        Object dataFile = null;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESAProcessXMLRequest: " + requestType);
        switch (requestType) {
            case 1: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_AUTHORIZE1");
                XMLfile = ESA_SDR_AUTHORIZE1_FILE;
                break;
            }
            case 2: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_AUTHORIZE2");
                XMLfile = ESA_SDR_AUTHORIZE2_FILE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESAEED type=" + requestType);
                XMLfile = ESA_SDR_EED_FILE;
                break;
            }
            case 6: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_FULLVPD");
                XMLfile = ESA_SDR_FULLVPD_FILE;
                break;
            }
            case 7: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_HEALTHCHECK");
                XMLfile = ESA_SDR_HEALTHCHECK_FILE;
                break;
            }
            case 8: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ESA_SDR_PMDATA");
                XMLfile = ESA_SDR_PMDATA_FILE;
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Invalid requestType....." + requestType);
            }
        }
        try {
            String filePath = BaseFileControl.getFilePath(ESA_PATH);
            File f = new File(filePath + XMLfile);
            FileInputStream fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            String aLine = null;
            while ((aLine = in.readLine()) != null) {
                xmlResults = xmlResults + aLine.trim();
            }
            in.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error reading xml file: exception e" + e);
        }
        Iterator i = xmlMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlMap key[" + e.getKey() + "] value[" + e.getValue() + "]");
            Pattern p = Pattern.compile((String)e.getKey());
            Matcher m = p.matcher("");
            m.reset(xmlResults);
            xmlResults = m.replaceAll((String)e.getValue());
        }
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xml.length()= " + xmlResults.length() + " XML results[" + xmlResults + "]");
        return xmlResults + "\n";
    }

    public static int ESASendAuthorizeRequest(int RequestMode, Map xmlParms) {
        String xmlResults;
        int rc = 0;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendAuthorizeRequest");
        int cmd = 1;
        String authorizationID = (String)xmlParms.get(ESA_KEY_PRIMARYID);
        if (xmlParms.containsKey(ESA_KEY_OPTIONALID)) {
            cmd = 2;
            authorizationID = authorizationID + "   " + (String)xmlParms.get(ESA_KEY_OPTIONALID);
        }
        if ((xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(cmd, xmlParms)).length() > 0) {
            SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
            SdrRequestBody sdrRB = new SdrRequestBody();
            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
            sdrRequest.requestType = "Authorization";
            sdrRequest.authorizationID = authorizationID;
            sdrRB.setUserAttachement(sdrRequest);
            sdrRB.addRequest(sdr);
            sdrRB.initializeMachineInformation();
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.web.authorize", "SaAuthReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return rc;
    }

    public static int ESASendEEDRequest(int RequestType2, String Mtms, String ProblemNumber, String Pmh, File EEDfile) {
        int nprob;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEEDRequest");
        int rc = 0;
        String machType = Mtms.substring(0, 4);
        String machModel = Mtms.substring(5, 8);
        String machSerial = Mtms.substring(9, 16);
        String problemUUID = null;
        String tPmh = null;
        String tProblemNumber = null;
        String altEEDFilename = null;
        String requestType = "DUMP";
        PIProblem theProblem = null;
        if (ProblemNumber != null && ProblemNumber.length() > 0 && (nprob = Integer.parseInt(ProblemNumber)) > 0) {
            tProblemNumber = ProblemNumber;
            try {
                ProblemManager pm = ProblemManager.getProblemManager();
                List problems = pm.filter(new ProblemNumberFilter(nprob, new PASystem(HMC.getHMC().getMachineType(), HMC.getHMC().getMachineModel(), HMC.getHMC().getMachineSerial())));
                if (problems.size() > 0 && (theProblem = (PIProblem)problems.get(0)) != null) {
                    altEEDFilename = theProblem.getEEDFilename();
                    problemUUID = theProblem.getUniqueKey();
                    if (theProblem.getPMH() != null && theProblem.getPMH().length() > 0) {
                        tPmh = theProblem.getPMH();
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PM exception");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        if (ServiceAgentUtils.isOEM()) {
            if (theProblem != null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] EED associated with problem");
                ServiceAgentUtils.notifyOEM("ProblemEED", theProblem);
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] EEDOnly request");
                ServiceAgentAttr.OEMeedOnlyInfo eedInfo = new ServiceAgentAttr.OEMeedOnlyInfo(machType, machModel, machSerial, EEDfile.getPath());
                ServiceAgentUtils.notifyOEM("DumpCallHome", eedInfo);
            }
        } else {
            rc = ServiceAgentUtils.scheduleXmitEED(new ServiceAgentAttr.ESAbatchEEDrequest(requestType, machType, machModel, machSerial, tProblemNumber, tPmh, problemUUID, EEDfile.getPath(), altEEDFilename));
        }
        return rc;
    }

    public static int ESASendEEDRequest(String requestType, String machType, String machModel, String machSerial, String ProblemNumber, String Pmh, String EEDFilename, String problemUUID, String altEEDFilename) {
        File EEDfile;
        int rc = 0;
        String xmlResults = "";
        String eedID = "";
        String Mtms = machType + "." + machModel + "." + machSerial;
        File myFile = EEDfile = new File(EEDFilename);
        String tPmh = "";
        String tProblemNumber = "";
        PIProblem theProblem = null;
        boolean forceSDR = false;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEEDRequest");
        if (Pmh == null || Pmh.length() <= 0) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Setting PMH to default");
            tPmh = ESA_PMH_DEFAULT;
        } else {
            tPmh = Pmh;
        }
        if (ProblemNumber == null || ProblemNumber.length() <= 0) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Setting ProblemNumber to default");
            tProblemNumber = ESA_PROB_DEFAULT;
        } else {
            tProblemNumber = ProblemNumber;
        }
        if (EEDfile.getPath().startsWith("/dump/")) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got a dump file: " + myFile.getPath());
            myFile = ServiceAgentUtils.processDump(myFile, 16000000);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(myFile.lastModified()));
        String prefix = Mtms + ".problem." + tProblemNumber + ".pmh." + tPmh + "." + requestType;
        String FileName = prefix + myFile.getPath();
        FileName = FileName.replaceAll("/", ".");
        FileName = FileName.replaceAll("-", ".");
        if (ServiceAgentUtils.getHmcType().equals("essHMC")) {
            String customerName = ServiceAgentUtils.getCustomerName();
            SimpleDateFormat dfMM = new SimpleDateFormat("yyMMddHHmmss", Locale.US);
            String datetimeMM = dfMM.format(new Date(myFile.lastModified()));
            String refcode = null;
            if (!tProblemNumber.equals(ESA_PROB_DEFAULT)) {
                int nprob = Integer.parseInt(tProblemNumber);
                if (nprob > 0) {
                    try {
                        ProblemManager pm = ProblemManager.getProblemManager();
                        if (problemUUID != null && problemUUID.length() > 0) {
                            theProblem = (PIProblem)pm.getProblem(problemUUID);
                        } else {
                            List problems = pm.filter(new ProblemNumberFilter(nprob, new PASystem(HMC.getHMC().getMachineType(), HMC.getHMC().getMachineModel(), HMC.getHMC().getMachineSerial())));
                            if (problems.size() > 0) {
                                theProblem = (PIProblem)problems.get(0);
                            }
                        }
                        if (theProblem != null) {
                            refcode = theProblem.getRefcode();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PM exception");
                        Trace.trace(TRACE_MASKF, e);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] nprob not set");
                }
            }
            String eedType = ".eed";
            if (requestType.equals("INIT_CALL_HOME_DATA_SET")) {
                if (refcode != null && refcode.length() > 0) {
                    try {
                        File f = new File("/opt/esshmc/data/eedfiletype");
                        FileInputStream fis = new FileInputStream(f);
                        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                        String aLine = null;
                        String[] parms = null;
                        while ((aLine = in.readLine()) != null) {
                            aLine = aLine.trim();
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] line eedfiletype: " + aLine);
                            parms = aLine.split(":");
                            if (parms.length == 2) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] refcode: " + parms[0] + " eedfiletype: " + parms[1]);
                                if (parms[0].equalsIgnoreCase("default")) {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] matched on default: " + parms[0] + " eedfiletype: " + parms[1]);
                                    eedType = "." + parms[1];
                                    continue;
                                }
                                if (!refcode.equalsIgnoreCase(parms[0])) continue;
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] matched on refcode: " + parms[0] + " eedfiletype: " + parms[1]);
                                eedType = "." + parms[1];
                                if (!eedType.equalsIgnoreCase(".pubkr")) continue;
                                forceSDR = true;
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] forceSDR: " + forceSDR);
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid length parsing parms");
                        }
                        in.close();
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error reading /opt/esshmc/data/eedfiletype");
                        Trace.trace(TRACE_MASKF, e);
                    }
                }
            } else if (requestType.equals("END_OF_CALL")) {
                eedType = ".endofcall";
            } else if (requestType.indexOf("DUMP") >= 0) {
                eedType = ".dump";
            }
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] eedType: " + eedType);
            altEEDFilename = machType + machModel + machSerial + "." + customerName + "." + tProblemNumber + "." + tPmh + "." + datetimeMM + ".cl9" + eedType + ".zip";
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] using MM naming: " + altEEDFilename);
            FileName = altEEDFilename;
            if (!myFile.getPath().endsWith(".zip")) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] package as zip: " + myFile.getPath());
                SimpleDateFormat dfZip = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                String datetimeZip = dfZip.format(new Date());
                String zipLocation = "";
                try {
                    zipLocation = BaseFileControl.getFilePath(ESA_PATH) + datetimeZip + "_" + requestType + ".zip";
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] BaseFileControl exception");
                    Trace.trace(TRACE_MASKF, e);
                }
                if (zipLocation != null && zipLocation.length() > 0) {
                    ArrayList<String> zipFiles = new ArrayList<String>(1);
                    zipFiles.add(myFile.getPath());
                    ServiceAgentUtils.buildZipFile(zipLocation, zipFiles, false);
                    myFile = new File(zipLocation);
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] zipLocation not set");
                }
            }
        }
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for EED Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   prefix:" + prefix);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                     file:" + myFile.getPath());
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]           altEEDFilename:" + altEEDFilename);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + myFile.length());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_FILENAME, FileName);
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(myFile.length()));
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(3, xmlParms);
        if (xmlResults.length() > 0) {
            SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, myFile);
            SdrRequestBody sdrRB = new SdrRequestBody();
            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
            sdrRequest.requestType = "Problem_EED";
            sdrRequest.problemUUID = problemUUID;
            sdrRequest.sdrFiles = new HashMap();
            boolean remove = false;
            if (!EEDfile.getPath().equals(myFile.getPath())) {
                remove = true;
            }
            ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(myFile.getPath(), EEDfile.getPath(), remove);
            sdrRequest.sdrFiles.put("EED", sdrFileInfo);
            sdrRB.setUserAttachement(sdrRequest);
            sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
            sdrRB.addRequest(sdr);
            if (forceSDR) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got forceSDR: " + forceSDR);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaEEDReq");
            } else {
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaEEDReq", myFile, prefix, remove, altEEDFilename, machType, problemUUID);
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return rc;
    }

    private static String getCustomerName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> getCustomerName");
        String cName = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo().getAdminCompany();
        String custName = "";
        if (cName != null && cName.length() > 0) {
            String custname = "";
            custname = cName.length() > 15 ? cName.substring(0, 15) : cName;
            StringBuffer sb = new StringBuffer(custname);
            for (int i = 0; i < custname.length(); ++i) {
                char ch = sb.charAt(i);
                if (Character.isDigit(ch) || Character.isLetter(ch)) continue;
                sb.setCharAt(i, '_');
            }
            custName = sb.toString();
        } else {
            custName = "Unavailable";
        }
        return custName;
    }

    public static String aixPMrequest(boolean sendit, String machType, String machModel, String machSerial, File PMfile, String dataType, String eventType) {
        int rc = 0;
        String xmlResults = "";
        String Mtms = machType + "." + machModel + "." + machSerial;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> aixPMrequest");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(PMfile.lastModified()));
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for AIX PM Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                     Mtms:" + Mtms);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + PMfile.length());
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 dataType:" + dataType);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                     file:" + PMfile.getPath());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(PMfile.length()));
        xmlParms.put(ESA_KEY_AIXPM_DATATYPE, dataType);
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(8, xmlParms);
        if (xmlResults.length() > 0) {
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sendit");
                SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, PMfile);
                SdrRequestBody sdrRB = new SdrRequestBody();
                sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
                sdrRB.addRequest(sdr);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", eventType);
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return xmlResults;
    }

    public static String ESAInventoryRequest(boolean sendit, String machType, String machModel, String machSerial, File Vpdfile) {
        int rc = 0;
        String xmlResults = "";
        String Mtms = machType + "." + machModel + "." + machSerial;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESAInventoryRequest");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String datetime = df.format(new Date(Vpdfile.lastModified()));
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for Inventory Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                 datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]                   length:" + Vpdfile.length());
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_EED_LENGTH, String.valueOf(Vpdfile.length()));
        xmlParms.put(ESA_KEY_VPD_NONDELTAREASON, "DELTA-PROCESSING-UNAVAILABLE");
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(6, xmlParms);
        if (xmlResults.length() > 0) {
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sendit");
                SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, Vpdfile);
                SdrRequestBody sdrRB = new SdrRequestBody();
                sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
                sdrRB.addRequest(sdr);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaVPDReq");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return xmlResults;
    }

    public static String ESAHealthCheckRequest(boolean sendit, String reportingSystem, String frequency, String status) {
        int rc = 0;
        String xmlResults = "";
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESAHealthCheckRequest");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String datetime = df.format(new Date());
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Settings for HealthCheck Request");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]        datetime:" + datetime);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] reportingSystem:" + reportingSystem);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       frequency:" + frequency);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]          status:" + status);
        HashMap<String, String> xmlParms = new HashMap<String, String>();
        xmlParms.put(ESA_KEY_EED_TIMESTAMP, datetime);
        xmlParms.put(ESA_KEY_HCHK_REPORTING_SYSTEM, reportingSystem);
        xmlParms.put(ESA_KEY_HCHK_FREQUENCY, frequency);
        xmlParms.put(ESA_KEY_HCHK_STATUS, status);
        xmlResults = ServiceAgentUtils.ESAProcessXMLRequest(7, xmlParms);
        if (xmlResults.length() > 0) {
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sendit");
                SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
                SdrRequestBody sdrRB = new SdrRequestBody();
                sdrRB.initializeMachineInformation();
                sdrRB.addRequest(sdr);
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaHealthReq");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] xmlResults not set");
        }
        return xmlResults;
    }

    public static boolean getEmailSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailSetting");
        boolean EmailSetting = false;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailSetting = cnp.EmailSetting;
        }
        return EmailSetting;
    }

    public static int setEmailSetting(boolean EmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailSetting");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailSetting = EmailSetting;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static String getEmailSMTPServer() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailSMTPServer");
        String EmailSMTPServer = "";
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailSMTPServer = cnp.EmailSMTPServer;
        }
        return EmailSMTPServer;
    }

    public static int setEmailSMTPServer(String EmailSMTPServer) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailSMTPServer");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailSMTPServer = EmailSMTPServer;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static int getEmailPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailPort");
        int EmailPort = 0;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailPort = cnp.EmailPort;
        }
        return EmailPort;
    }

    public static int setEmailPort(int EmailPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setEmailPort");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            cnp.EmailPort = EmailPort;
            rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static boolean getFtpOffLoadSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpOffLoadSetting");
        boolean FtpOffLoadSetting = false;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpOffLoadSetting = ftp.FtpOffLoadSetting;
        }
        return FtpOffLoadSetting;
    }

    public static int setFtpOffLoadSetting(boolean FtpOffLoadSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpOffLoadSetting");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpOffLoadSetting = FtpOffLoadSetting;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerName");
        String FtpServerName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerName = ftp.FtpServerName;
        }
        return FtpServerName;
    }

    public static int setFtpServerName(String FtpServerName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerName");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerName = FtpServerName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerDirectory() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerDirectory");
        String FtpServerDirectory = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerDirectory = ftp.FtpServerDirectory;
        }
        return FtpServerDirectory;
    }

    public static int setFtpServerDirectory(String FtpServerDirectory) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerDirectory");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerDirectory = FtpServerDirectory;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerUserName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerUserName");
        String FtpServerUserName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerUserName = ftp.FtpServerUserName;
        }
        return FtpServerUserName;
    }

    public static int setFtpServerUserName(String FtpServerUserName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerUserName");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerUserName = FtpServerUserName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerUserPassword() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerUserPassword");
        String FtpServerUserPassword = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerUserPassword = ftp.FtpServerUserPassword;
        }
        return FtpServerUserPassword;
    }

    public static int setFtpServerUserPassword(String FtpServerUserPassword) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerUserPassword");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerUserPassword = FtpServerUserPassword;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static int getFtpPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpPort");
        int FtpPort = 0;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpPort = ftp.FtpPort;
        }
        return FtpPort;
    }

    public static int setFtpPort(int FtpPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpPort");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpPort = FtpPort;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpServerPassiveMode() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpServerPassiveMode");
        String FtpServerPassiveMode = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpServerPassiveMode = ftp.FtpServerPassiveMode;
        }
        return FtpServerPassiveMode;
    }

    public static int setFtpServerPassiveMode(String FtpServerPassiveMode) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpServerPassiveMode");
        int rc = 9;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpServerPassiveMode = FtpServerPassiveMode;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static boolean getFtpFirewallSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallSetting");
        boolean FtpFirewallSetting = false;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallSetting = ftp.FtpFirewallSetting;
        }
        return FtpFirewallSetting;
    }

    public static int setFtpFirewallSetting(boolean FtpFirewallSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallSetting");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallSetting = FtpFirewallSetting;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallType() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallType");
        String FtpFirewallType = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallType = ftp.FtpFirewallType;
        }
        return FtpFirewallType;
    }

    public static int setFtpFirewallType(String FtpFirewallType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallType");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallType = FtpFirewallType;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallHostName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallHostName");
        String FtpFirewallHostName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallHostName = ftp.FtpFirewallHostName;
        }
        return FtpFirewallHostName;
    }

    public static int setFtpFirewallHostName(String FtpFirewallHostName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallHostName");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallHostName = FtpFirewallHostName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallUserName() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallUserName");
        String FtpFirewallUserName = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallUserName = ftp.FtpFirewallUserName;
        }
        return FtpFirewallUserName;
    }

    public static int setFtpFirewallUserName(String FtpFirewallUserName) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallUserName");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallUserName = FtpFirewallUserName;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallUserPassword() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallUserPassword");
        String FtpFirewallUserPassword = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallUserPassword = ftp.FtpFirewallUserPassword;
        }
        return FtpFirewallUserPassword;
    }

    public static int setFtpFirewallUserPassword(String FtpFirewallUserPassword) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallUserPassword");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallUserPassword = FtpFirewallUserPassword;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallExclusionList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallExclusionList");
        String FtpFirewallExclusionList = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallExclusionList = ftp.FtpFirewallExclusionList;
        }
        return FtpFirewallExclusionList;
    }

    public static int setFtpFirewallExclusionList(String FtpFirewallExclusionList) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallExclusionList");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallExclusionList = FtpFirewallExclusionList;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static String getFtpFirewallPassiveMode() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallPassiveMode");
        String FtpFirewallPassiveMode = "";
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallPassiveMode = ftp.FtpFirewallPassiveMode;
        }
        return FtpFirewallPassiveMode;
    }

    public static int setFtpFirewallPassiveMode(String FtpFirewallPassiveMode) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallPassiveMode");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallPassiveMode = FtpFirewallPassiveMode;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static int getFtpFirewallPort() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getFtpFirewallPort");
        int FtpFirewallPort = 0;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            FtpFirewallPort = ftp.FtpFirewallPort;
        }
        return FtpFirewallPort;
    }

    public static int setFtpFirewallPort(int FtpFirewallPort) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setFtpFirewallPort");
        int rc = 12;
        FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
        if (ftp != null) {
            ftp.FtpFirewallPort = FtpFirewallPort;
            rc = ServiceAgentUtils.writeFtpOffLoadPersistable(ftp);
        }
        return rc;
    }

    public static Map getEmailList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getEmailList");
        Map EmailList = null;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            EmailList = cnp.EmailList;
        }
        return EmailList;
    }

    public static int addEmailEntry(String EmailAddress, String EmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] addEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            if (cnp.EmailList.containsKey(EmailAddress.toUpperCase())) {
                rc = 1;
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] EmailAddress[" + EmailAddress + "] already exists");
            } else {
                EmailValueObject Emailobj = new EmailValueObject();
                Emailobj.EmailAddress = EmailAddress;
                Emailobj.EmailSetting = EmailSetting;
                cnp.EmailList.put(EmailAddress.toUpperCase(), Emailobj);
                rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
            }
        }
        return rc;
    }

    public static int updateEmailEntry(String EmailAddress, String newEmailAddress, String newEmailSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]    EmailAddress[" + EmailAddress + "]");
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] newEmailAddress[" + newEmailAddress + "]");
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] newEmailSetting[" + newEmailSetting + "]");
            if (!EmailAddress.equals(newEmailAddress.toUpperCase()) && cnp.EmailList.containsKey(newEmailAddress.toUpperCase())) {
                rc = 1;
            } else if (null == cnp.EmailList.remove(EmailAddress.toUpperCase())) {
                rc = 2;
            } else {
                EmailValueObject Emailobj = new EmailValueObject();
                Emailobj.EmailAddress = newEmailAddress;
                Emailobj.EmailSetting = newEmailSetting;
                cnp.EmailList.put(newEmailAddress.toUpperCase(), Emailobj);
                rc = ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
            }
        }
        return rc;
    }

    public static int removeEmailEntry(String keyEmailAddress) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] removeEmailEntry");
        int rc = 3;
        CustomerNotifyPersistable cnp = ServiceAgentUtils.readCustomerNotifyPersistable();
        if (cnp != null) {
            rc = null == cnp.EmailList.remove(keyEmailAddress) ? 2 : ServiceAgentUtils.writeCustomerNotifyPersistable(cnp);
        }
        return rc;
    }

    public static int removeAllEmailEntries() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] removeAllEmailEntries");
        HashMap workEmailList = new HashMap(ServiceAgentUtils.getEmailList());
        int rc = 0;
        Iterator i = workEmailList.keySet().iterator();
        while (i.hasNext()) {
            rc = ServiceAgentUtils.removeEmailEntry((String)i.next());
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    public static int sendEmailMsgToAddresses(String[] emailAddresses, LocalizableText subject, LocalizableText message) {
        HashMap results = null;
        int rc = ServiceAgentUtils.sendEmailMsgToAddresses(emailAddresses, subject, message, results);
        return rc;
    }

    public static int sendEmailMsgToAddresses(String[] emailAddresses, LocalizableText subject, LocalizableText message, HashMap results) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] sendEmailMsgToAddresses");
        if (results == null) {
            results = new HashMap<String, String>();
        } else {
            results.clear();
        }
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, "SaEmailNtfy", null, null, null, null);
        int rc = 0;
        String from = new LocalizableText(ESAMSG, "ESA.email.from").toString();
        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
            from = from + "@" + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
        }
        String emailAddr = "";
        String EmailSMTPServer = ServiceAgentUtils.getEmailSMTPServer();
        int EmailPort = ServiceAgentUtils.getEmailPort();
        try {
            for (int i = 0; i < emailAddresses.length; ++i) {
                emailAddr = emailAddresses[i];
                Emailer email = new Emailer(EmailSMTPServer, EmailPort);
                email.send(emailAddr, from, subject.toString(), message.toString());
                results.put(emailAddr, "SaEmailSuc");
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Email sent to: " + emailAddresses[i]);
            }
        }
        catch (Exception e) {
            results.put(emailAddr, "SaEmailErr");
            block = (byte)(block + 1);
            theLog.add(block, e);
            rc = 3;
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] send exception: " + e);
        }
        theLog.add((byte)3, "SMTPServer[" + EmailSMTPServer + "] Port[" + Integer.toString(EmailPort) + "] subject[" + subject.toString(Locale.US) + "] message[" + message.toString(Locale.US));
        String res = "";
        Iterator j = results.entrySet().iterator();
        while (j.hasNext()) {
            Map.Entry e = j.next();
            res = res + (String)e.getKey() + "[" + (String)e.getValue() + "]";
        }
        block = (byte)(block + 1);
        theLog.add(block, res);
        theLog.log();
        return rc;
    }

    public static int ESASendEmailMsg(String calledhome, LocalizableText subject, LocalizableText message) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] ESASendEmailMsg (all addresses)");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] message.toString[" + message.toString() + "]");
        HashMap workEmailList = new HashMap(ServiceAgentUtils.getEmailList());
        ArrayList<String> emailList = new ArrayList<String>(workEmailList.size());
        Iterator i = workEmailList.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            EmailValueObject Emailobj = (EmailValueObject)e.getValue();
            if (Emailobj.EmailSetting.equals(ESA_ALL) || Emailobj.EmailSetting.equals(ESA_CALLHOMEONLY) && calledhome.equals("Y")) {
                emailList.add(Emailobj.EmailAddress);
                continue;
            }
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Email filtered: " + Emailobj.EmailAddress);
        }
        String[] addressArray = new String[emailList.size()];
        for (int i2 = 0; i2 < addressArray.length; ++i2) {
            addressArray[i2] = (String)emailList.get(i2);
        }
        HashMap results = new HashMap();
        return ServiceAgentUtils.sendEmailMsgToAddresses(addressArray, subject, message, results);
    }

    public static boolean getExecutionSetting() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getExecutionSetting");
        boolean ExecutionSetting = false;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            ExecutionSetting = cnp.ExecutionSetting;
        }
        return ExecutionSetting;
    }

    public static int setExecutionSetting(boolean ExecutionSetting) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setExecutionSetting");
        int rc = 6;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            cnp.ExecutionSetting = ExecutionSetting;
            rc = ServiceAgentUtils.writeXMITServiceInfoPersistable(cnp);
        }
        return rc;
    }

    public static int getExecutionFrequency() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getExecutionFrequency");
        int ExecutionFrequency = 0;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            ExecutionFrequency = cnp.ExecutionFrequency;
        }
        return ExecutionFrequency;
    }

    public static int setExecutionFrequency(int ExecutionFrequency) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setExecutionFrequency");
        int rc = 6;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            cnp.ExecutionFrequency = ExecutionFrequency;
            rc = ServiceAgentUtils.writeXMITServiceInfoPersistable(cnp);
        }
        return rc;
    }

    public static long getExecutionTimeOfDay() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getExecutionTimeOfDay");
        long ExecutionTimeOfDay = 0L;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            ExecutionTimeOfDay = cnp.ExecutionTimeOfDay;
        }
        return ExecutionTimeOfDay;
    }

    public static int setExecutionTimeOfDay(long ExecutionTimeOfDay) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] setExecutionTimeOfDay");
        int rc = 6;
        XMITServiceInfoPersistable cnp = ServiceAgentUtils.readXMITServiceInfoPersistable();
        if (cnp != null) {
            cnp.ExecutionTimeOfDay = ExecutionTimeOfDay;
            rc = ServiceAgentUtils.writeXMITServiceInfoPersistable(cnp);
        }
        return rc;
    }

    private static CustomerNotifyPersistable readCustomerNotifyPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readCustomerNotifyPersistable");
        CustomerNotifyPersistable cnp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            cnp = (CustomerNotifyPersistable)pMgr.read(ESA_CUSTOMER_NOTIFY_PERSIST);
            if (cnp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify persisted data not initialized");
                cnp = new CustomerNotifyPersistable();
                pMgr.write(ESA_CUSTOMER_NOTIFY_PERSIST, cnp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify persisted data exception" + exc);
            cnp = new CustomerNotifyPersistable();
            cnp = (CustomerNotifyPersistable)ServiceAgentUtils.handlePersistenceException(cnp, F_ESA_CUSTOMER_NOTIFY_PERSIST, ESA_CUSTOMER_NOTIFY_PERSIST, pMgr);
        }
        return cnp;
    }

    private static int writeCustomerNotifyPersistable(CustomerNotifyPersistable cnp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeCustomerNotifyPersistable");
        int rc = 0;
        if (cnp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_CUSTOMER_NOTIFY_PERSIST, cnp);
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] CustomerNotify write persisted data exception" + exc);
                rc = 1;
            }
        } else {
            rc = 2;
        }
        return rc;
    }

    private static FtpOffLoadPersistable readFtpOffLoadPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readFtpOffLoadPersistable");
        FtpOffLoadPersistable ftp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            ftp = (FtpOffLoadPersistable)pMgr.read(ESA_FTP_OFFLOAD_PERSIST);
            if (ftp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad persisted data not initialized");
                ftp = new FtpOffLoadPersistable();
                if (ServiceAgentUtils.getHmcType().equals("essHMC")) {
                    ftp.FtpOffLoadSetting = false;
                    ftp.FtpServerName = "testcase.boulder.ibm.com";
                    ftp.FtpServerDirectory = "/ssd/toibm/squadrondumps/";
                    ftp.FtpServerUserName = "anonymous";
                    ftp.FtpServerUserPassword = "ssd@ibm.com";
                    ftp.FtpServerPassiveMode = "on";
                    ftp.FtpPort = 21;
                    ftp.FtpFirewallSetting = false;
                    ftp.FtpFirewallType = "0";
                    ftp.FtpFirewallHostName = "";
                    ftp.FtpFirewallUserName = "";
                    ftp.FtpFirewallUserPassword = "";
                    ftp.FtpFirewallExclusionList = "";
                    ftp.FtpFirewallPassiveMode = "on";
                    ftp.FtpFirewallPort = 21;
                } else {
                    String from = "ElectronicServiceAgent@hmc.com";
                    NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                    if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                        from = "ElectronicServiceAgent@" + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                    }
                    ftp.FtpOffLoadSetting = false;
                    ftp.FtpServerName = "testcase.boulder.ibm.com";
                    ftp.FtpServerDirectory = "/hardware/toibm/edddata/";
                    ftp.FtpServerUserName = "anonymous";
                    ftp.FtpServerUserPassword = from;
                    ftp.FtpServerPassiveMode = "on";
                    ftp.FtpPort = 21;
                    ftp.FtpFirewallSetting = false;
                    ftp.FtpFirewallType = "0";
                    ftp.FtpFirewallHostName = "";
                    ftp.FtpFirewallUserName = "";
                    ftp.FtpFirewallUserPassword = "";
                    ftp.FtpFirewallExclusionList = "";
                    ftp.FtpFirewallPassiveMode = "on";
                    ftp.FtpFirewallPort = 21;
                }
                pMgr.write(ESA_FTP_OFFLOAD_PERSIST, ftp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad persisted data exception" + exc);
            ftp = new FtpOffLoadPersistable();
            if (ServiceAgentUtils.getHmcType().equals("essHMC")) {
                ftp.FtpOffLoadSetting = false;
                ftp.FtpServerName = "testcase.boulder.ibm.com";
                ftp.FtpServerDirectory = "/ssd/toibm/squadrondumps/";
                ftp.FtpServerUserName = "anonymous";
                ftp.FtpServerUserPassword = "ssd@ibm.com";
                ftp.FtpServerPassiveMode = "on";
                ftp.FtpPort = 21;
                ftp.FtpFirewallSetting = false;
                ftp.FtpFirewallType = "0";
                ftp.FtpFirewallHostName = "";
                ftp.FtpFirewallUserName = "";
                ftp.FtpFirewallUserPassword = "";
                ftp.FtpFirewallExclusionList = "";
                ftp.FtpFirewallPassiveMode = "on";
                ftp.FtpFirewallPort = 21;
            } else {
                String from = "ElectronicServiceAgent@hmc.com";
                NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                    from = "ElectronicServiceAgent@" + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                }
                ftp.FtpOffLoadSetting = false;
                ftp.FtpServerName = "testcase.boulder.ibm.com";
                ftp.FtpServerDirectory = "/hardware/toibm/edddata/";
                ftp.FtpServerUserName = "anonymous";
                ftp.FtpServerUserPassword = from;
                ftp.FtpServerPassiveMode = "on";
                ftp.FtpPort = 21;
                ftp.FtpFirewallSetting = false;
                ftp.FtpFirewallType = "0";
                ftp.FtpFirewallHostName = "";
                ftp.FtpFirewallUserName = "";
                ftp.FtpFirewallUserPassword = "";
                ftp.FtpFirewallExclusionList = "";
                ftp.FtpFirewallPassiveMode = "on";
                ftp.FtpFirewallPort = 21;
            }
            ftp = (FtpOffLoadPersistable)ServiceAgentUtils.handlePersistenceException(ftp, F_ESA_FTP_OFFLOAD_PERSIST, ESA_FTP_OFFLOAD_PERSIST, pMgr);
        }
        return ftp;
    }

    private static int writeFtpOffLoadPersistable(FtpOffLoadPersistable ftp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeFtpOffLoadPersistable");
        int rc = 0;
        if (ftp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_FTP_OFFLOAD_PERSIST, ftp);
                rc = ServiceAgentUtils.updateFtpFirewallFile();
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad write persisted data exception" + exc);
                rc = 7;
            }
        } else {
            rc = 8;
        }
        return rc;
    }

    private static Object handlePersistenceException(Object pObj, String realFile, String persistenceFile, PersistenceManager pMgr) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] handlePersistenceException");
        Object returnObj = null;
        boolean result = false;
        try {
            String filePath = BaseFileControl.getFilePath("persist");
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] checking for filePath: " + filePath);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] checking for fileName: " + realFile);
            File f = new File(filePath + realFile);
            if (f != null && f.isFile()) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] try to delete file: " + f.getPath());
                result = f.delete();
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] delete result: " + result);
            }
        }
        catch (Exception ioexc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] IOException");
            Trace.trace(TRACE_MASKF, ioexc);
        }
        if (result) {
            try {
                pMgr.write(persistenceFile, (Persistable)pObj);
                returnObj = pObj;
            }
            catch (PersistenceException sexc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PersistenceException");
                Trace.trace(TRACE_MASKF, sexc);
            }
        }
        return returnObj;
    }

    public static int updateFtpFirewallFile() {
        int rc;
        block9: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] updateFtpFirewallFile");
            rc = 0;
            FtpOffLoadPersistable ftp = ServiceAgentUtils.readFtpOffLoadPersistable();
            if (ftp != null) {
                HashMap<String, String> firewallMap = new HashMap<String, String>();
                if (ftp.FtpFirewallSetting) {
                    firewallMap.put(ESA_KEY_FtpFirewallType, ftp.FtpFirewallType);
                } else {
                    firewallMap.put(ESA_KEY_FtpFirewallType, "0");
                }
                firewallMap.put(ESA_KEY_FtpFirewallHostName, ftp.FtpFirewallHostName);
                firewallMap.put(ESA_KEY_FtpFirewallUserName, ftp.FtpFirewallUserName);
                firewallMap.put(ESA_KEY_FtpFirewallUserPassword, ftp.FtpFirewallUserPassword);
                firewallMap.put(ESA_KEY_FtpFirewallPort, String.valueOf(ftp.FtpFirewallPort));
                firewallMap.put(ESA_KEY_FtpFirewallExclusionList, ftp.FtpFirewallExclusionList);
                firewallMap.put(ESA_KEY_FtpFirewallPassiveMode, ftp.FtpFirewallPassiveMode);
                try {
                    String filePath = BaseFileControl.getFilePath(ESA_PATH);
                    String tmpOutfile = filePath + "temp" + ESA_FTP_FIREWALL_FILE;
                    File outFile = new File(tmpOutfile);
                    FileWriter out = new FileWriter(outFile);
                    File inFile = new File(filePath + ESA_FTP_FIREWALL_FILE);
                    FileInputStream fis = new FileInputStream(inFile);
                    BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                    String aLine = null;
                    while ((aLine = in.readLine()) != null) {
                        aLine = aLine.trim();
                        Iterator i = firewallMap.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] firewallMap key[" + e.getKey() + "] value[" + e.getValue() + "]");
                            Pattern p = Pattern.compile((String)e.getKey());
                            Matcher m = p.matcher("");
                            m.reset(aLine);
                            aLine = m.replaceAll((String)e.getValue());
                        }
                        out.write(aLine + "\n");
                    }
                    out.close();
                    in.close();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] moving file[" + tmpOutfile + "] to [" + ESA_FTP_FIREWALL_SAVE_FILE + "]");
                    Process pid = RootProcess.startProgram("mvFile " + tmpOutfile + " " + ESA_FTP_FIREWALL_SAVE_FILE);
                    if (pid != null) {
                        rc = pid.waitFor();
                        break block9;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error processing firewall files");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ftp was null");
            }
        }
        return rc;
    }

    private static XMITServiceInfoPersistable readXMITServiceInfoPersistable() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] readXMITServiceInfoPersistable");
        XMITServiceInfoPersistable cnp = null;
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            cnp = (XMITServiceInfoPersistable)pMgr.read(ESA_XMIT_SERVICE_INFO_PERSIST);
            if (cnp == null) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo persisted data not initialized");
                cnp = new XMITServiceInfoPersistable();
                cnp.ExecutionFrequency = 7;
                Date dt = new Date();
                cnp.ExecutionTimeOfDay = dt.getTime();
                pMgr.write(ESA_XMIT_SERVICE_INFO_PERSIST, cnp);
            }
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo persisted data exception" + exc);
            cnp = new XMITServiceInfoPersistable();
            cnp = (XMITServiceInfoPersistable)ServiceAgentUtils.handlePersistenceException(cnp, F_ESA_XMIT_SERVICE_INFO_PERSIST, ESA_XMIT_SERVICE_INFO_PERSIST, pMgr);
        }
        return cnp;
    }

    private static int writeXMITServiceInfoPersistable(XMITServiceInfoPersistable cnp) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] writeXMITServiceInfoPersistable");
        int rc = 0;
        if (cnp != null) {
            PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
            try {
                pMgr.write(ESA_XMIT_SERVICE_INFO_PERSIST, cnp);
            }
            catch (PersistenceException exc) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] XMITServiceInfo write persisted data exception" + exc);
                rc = 4;
            }
        } else {
            rc = 5;
        }
        return rc;
    }

    private static int SdrSubmit(SdrRequestBody sdrRB, String requestType, String eventType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] SdrSubmit");
        int rc = 0;
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, eventType, null, null, null, null);
        ArrayList aList = sdrRB.getRequestList();
        if (aList != null) {
            for (int i = 0; i < aList.size(); ++i) {
                SdrHttpRequest httpRequest = (SdrHttpRequest)aList.get(i);
                block = (byte)(block + 1);
                theLog.add(block, httpRequest.getXmlData());
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] aList wass null");
        }
        RemoteSupportFacility rsfImpl = RsfManager.getRsfManager().getConsoleRsf();
        RsfRequest request = rsfImpl.newRequestInstance(sdrRB, "com.ibm.hwmca.p.sa.ESARsfResultProcessor", new LocalizableText(ESAMSG, requestType));
        try {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] submit RsfRequest");
            request.submit();
            theLog.add((byte)3, request.getId());
            theLog.log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] submit() exception " + e);
            rc = 1;
        }
        return rc;
    }

    private static int SdrSubmit(SdrRequestBody sdrRB, String requestType, String eventType, File file, String prefix, boolean remove, String EEDFilename, String machType, String problemUUID) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] SdrSubmit");
        int rc = 0;
        if (ServiceAgentUtils.getFtpOffLoadSetting()) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad was true");
            rc = ServiceAgentUtils.FtpOffLoad(file.getPath(), prefix, EEDFilename, machType, problemUUID);
            if (rc == 0) {
                if (remove) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Delete file: " + file.getPath());
                    file.delete();
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad failed rc=" + rc + ".  Use backup path.");
                rc = ServiceAgentUtils.SdrSubmit(sdrRB, requestType, eventType);
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FtpOffLoad was false.  Use backup path.");
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, requestType, eventType);
        }
        return rc;
    }

    public static int FtpOffLoad(String fileName, String prefix, String EEDFilename, String machType, String problemUUID) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] FtpOffLoad");
        int rc = 0;
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, "SaFTPReq", null, null, null, null);
        String ftpServerDirectory = ServiceAgentUtils.getFtpServerDirectory();
        if (ServiceAgentUtils.getHmcType().equals("ipHMC")) {
            ftpServerDirectory = ftpServerDirectory + machType + "/";
        }
        String toFilename = "";
        toFilename = EEDFilename != null && EEDFilename.length() > 0 ? EEDFilename : prefix + fileName.replaceAll("/", ".");
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]    fileName: " + fileName);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]      prefix: " + prefix);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] EEDFilename: " + EEDFilename);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]  toFilename: " + toFilename);
        theLog.add((byte)3, "TOFILENAME=" + toFilename + "FILENAME=" + fileName + "PREFIX=" + prefix + "EEDFILENAME=" + EEDFilename);
        block = (byte)(block + 1);
        theLog.add(block, ServiceAgentUtils.readFtpOffLoadPersistable());
        theLog.log();
        String passiveMode = ServiceAgentUtils.getFtpServerPassiveMode();
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] passive mode: " + passiveMode);
        passiveMode = passiveMode.equalsIgnoreCase("on") ? " -F " : " -E ";
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] using passive mode: " + passiveMode);
        String debugFile = "";
        try {
            debugFile = BaseFileControl.getFilePath(ESA_PATH) + toFilename + ".FTPDEBUG";
            Process pid = RootProcess.startProgram("saFtpOffLoad " + fileName + " " + ServiceAgentUtils.getFtpServerUserName() + " " + ServiceAgentUtils.getFtpServerUserPassword() + " " + ServiceAgentUtils.getFtpPort() + " " + passiveMode + " " + debugFile + " " + ServiceAgentUtils.getFtpServerName() + " " + ftpServerDirectory + toFilename);
            rc = pid.waitFor();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid rc: " + rc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        String debugInfo = "";
        try {
            File f = new File(debugFile);
            if (f != null) {
                FileInputStream fis = new FileInputStream(f);
                if (fis != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                    if (in != null) {
                        String aLine = null;
                        while ((aLine = in.readLine()) != null) {
                            debugInfo = debugInfo + aLine;
                        }
                        in.close();
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] BufferedReader was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] FileInputStream was null");
                }
                f.delete();
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] File was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Error reading debugFile" + debugFile);
            Trace.trace(TRACE_MASKF, e);
        }
        LocalizableText errorMessage = null;
        switch (rc) {
            case 0: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC0");
                break;
            }
            case 1: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC1");
                break;
            }
            case 2: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC2");
                break;
            }
            case 3: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC3");
                break;
            }
            case 4: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC4");
                break;
            }
            case 5: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC5");
                break;
            }
            case 6: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC6");
                break;
            }
            case 7: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC7");
                break;
            }
            case 8: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC8");
                break;
            }
            case 9: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC9");
                break;
            }
            case 10: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC10");
                break;
            }
            case 11: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RC11");
                break;
            }
            default: {
                errorMessage = new LocalizableText(ESAMSG, "ESA.ncftpput.RCunknown");
            }
        }
        block = 3;
        theLog = new Log(-86, -45, 0, "SaFTPRes", null, null, null, null);
        theLog.add((byte)3, "TOFILENAME=" + toFilename + "FILENAME=" + fileName + "PREFIX=" + prefix + "EEDFILENAME=" + EEDFilename);
        block = (byte)(block + 1);
        theLog.add(block, ServiceAgentUtils.readFtpOffLoadPersistable());
        block = (byte)(block + 1);
        theLog.add(block, "SAFTPOFFLOAD_RC=" + rc + " " + errorMessage.toString(Locale.US));
        block = (byte)(block + 1);
        theLog.add(block, "ncftpput_DebugFile=" + debugInfo);
        theLog.log();
        String subject = "";
        String message = "";
        String details = "";
        String pmh = "";
        String problem = "";
        String failingsystem = "";
        String failingmtms = "";
        String from = "";
        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
            from = networkInfo.getComputerName() + "." + networkInfo.getDomainName();
        }
        subject = new LocalizableText(ESAMSG, "ESA.email.ncftpput.subject").toString();
        LocalizableText eventMessage = null;
        if (rc == 0) {
            message = new LocalizableText(ESAMSG, "ESA.email.ncftpput.success").toString();
            eventMessage = new LocalizableText(ESAMSG, "ESA.cem.ncftpput.success");
        } else {
            message = new LocalizableText(ESAMSG, "ESA.email.ncftpput.failure").toString();
            eventMessage = new LocalizableText(ESAMSG, "ESA.cem.ncftpput.failure");
        }
        details = details + "\n";
        details = details + "\nEED: " + fileName;
        details = details + "\n";
        if (problemUUID != null && problemUUID.length() > 0) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got problemUUID: " + problemUUID);
            try {
                ProblemManager pm = ProblemManager.getProblemManager();
                PIProblem theProblem = (PIProblem)pm.getProblem(problemUUID);
                if (theProblem != null) {
                    problem = String.valueOf(theProblem.getProblemNumber());
                    pmh = theProblem.getPMH();
                    if (theProblem.getReportingRemoteMachineSystem() != null && theProblem.getReportingRemoteMachineSystem().getMOSystemName() != null) {
                        failingsystem = theProblem.getReportingRemoteMachineSystem().getMOSystemName();
                    }
                    if (networkInfo != null && failingsystem != null && failingsystem.length() == 0) {
                        failingsystem = networkInfo.getComputerName();
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] failingsystem: " + failingsystem);
                    if (theProblem.getFailingSystem().getMTMS() != null) {
                        failingmtms = theProblem.getFailingSystem().getMTMS();
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] failingmtms: " + failingmtms);
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] problem manager exception");
                Trace.trace(TRACE_MASKF, e);
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] problemUUID not set");
        }
        if (failingsystem.length() > 0) {
            details = details + "\n" + new LocalizableText(ESAMSG, "ESA.email.reportingsystem", new String[]{failingsystem}).toString();
        }
        if (failingmtms.length() > 0) {
            details = details + "\n" + new LocalizableText(ESAMSG, "ESA.email.mtms", new String[]{failingmtms}).toString();
        }
        if (problem.length() > 0) {
            details = details + "\n" + new LocalizableText(ESAMSG, "ESA.email.problemnumber", new String[]{problem}).toString();
        }
        if (pmh != null && pmh.length() > 0) {
            details = details + "\n" + new LocalizableText(ESAMSG, "ESA.email.pmrnumber", new String[]{pmh}).toString();
        }
        details = details + "\n" + new LocalizableText(ESAMSG, "ESA.email.details").toString() + " " + errorMessage.toString();
        eventMessage.setSubst(new String[]{details.replaceAll("\n", " ")});
        SystemEventLog logEvent = new SystemEventLog(eventMessage, theLog.getEventName());
        logEvent.log();
        if (ServiceAgentUtils.getEmailSetting()) {
            ServiceAgentUtils.ESASendEmailMsg("N", new LocalizableText(subject + " from " + from), new LocalizableText(message + details));
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] email not enabled");
        }
        return rc;
    }

    public static String[] getMtmsList() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getMtmsList");
        int rc = 0;
        String[] MtmsArray = null;
        try {
            Process pid = RootProcess.startProgram("lsHSC -t0");
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String machCat = "";
                String machType = "";
                String machModel = "";
                String machSerial = "";
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer before replace: " + buffer);
                    if (buffer.length() > 1) {
                        buffer = buffer.replaceAll(";|:|\\.|_|-", " ").trim();
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer after replace: " + buffer);
                        StringTokenizer st = new StringTokenizer(buffer, " ");
                        if (st.countTokens() % 4 == 0) {
                            int i;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of tokens: " + st.countTokens());
                            int reps = st.countTokens() / 4;
                            ArrayList<String> tmpList = new ArrayList<String>(reps);
                            for (i = 0; i < reps; ++i) {
                                machCat = st.nextToken();
                                machType = st.nextToken();
                                machModel = st.nextToken();
                                machSerial = st.nextToken();
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machCat: " + machCat);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machType: " + machType);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machModel: " + machModel);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] machSerial: " + machSerial);
                                if (!machType.equals("0")) {
                                    tmpList.add(machCat + " " + machType + " " + machModel + " " + machSerial);
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid machine specified");
                            }
                            if (tmpList.size() > 0) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of machines to process: " + tmpList.size());
                                MtmsArray = tmpList.toArray(new String[tmpList.size()]);
                                if (MtmsArray != null) {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray.length: " + MtmsArray.length);
                                    for (i = 0; i < MtmsArray.length; ++i) {
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray[" + i + "] = " + MtmsArray[i]);
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] MtmsArray was null");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no machines to process");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid number of tokens: " + st.countTokens());
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return MtmsArray;
    }

    public static int collectVpdFromMtms(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] collectVpdFromMtms");
        int rc = 0;
        try {
            Process pid = RootProcess.startProgram("invSCOUT -v -m " + machType + "-" + machModel + " -s " + machSerial);
            rc = pid.waitFor();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid rc: " + rc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return rc;
    }

    public static int XmitScheduled(String requestType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitScheduled");
        int rc = 0;
        rc = ServiceAgentUtils.XmitImmediate(requestType);
        return rc;
    }

    public static int XmitImmediate(String requestType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitImmediate");
        String eventType = "SaXmtImmReq";
        if (requestType.equals("Xmit_Scheduled")) {
            eventType = "SaXmtSchReq";
        }
        int rc = 0;
        Map[] mapArray = ServiceAgentUtils.getSystemInfo();
        if (mapArray != null) {
            for (int i = 0; i < mapArray.length; ++i) {
                Map tmpMap = mapArray[i];
                String name = (String)tmpMap.get("name");
                if (name != null) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] working with system: " + name);
                    String type_model = (String)tmpMap.get("type_model");
                    String serial_num = (String)tmpMap.get("serial_num");
                    String state = (String)tmpMap.get("state");
                    String cod_mem_capable = (String)tmpMap.get("cod_mem_capable");
                    String cod_proc_capable = (String)tmpMap.get("cod_proc_capable");
                    String sp_version = (String)tmpMap.get("sp_version");
                    if (type_model != null && serial_num != null) {
                        String[] mtypemodel = type_model.split("-|_");
                        if (mtypemodel.length == 2) {
                            String fileName = "";
                            ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
                            sdrRequest.requestType = requestType;
                            sdrRequest.sdrFiles = new HashMap();
                            SdrRequestBody sdrRB = new SdrRequestBody();
                            sdrRB.setReportingMachineInfo(new RsfMachineInfo(mtypemodel[0], mtypemodel[1], serial_num));
                            fileName = "/var/adm/invscout/" + mtypemodel[0] + "-" + mtypemodel[1] + "_" + serial_num + ".VPD.xml";
                            ServiceAgentAttr.ESAsdrFileInfo vpdFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
                            sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD output file: " + fileName);
                            rc = ServiceAgentUtils.collectVpdFromMtms(mtypemodel[0], mtypemodel[1], serial_num);
                            File vpdFile = new File(fileName);
                            if (vpdFile != null) {
                                if (vpdFile.length() > 0L) {
                                    String xmlResults = ServiceAgentUtils.ESAInventoryRequest(false, mtypemodel[0], mtypemodel[1], serial_num, vpdFile);
                                    if (xmlResults.length() > 0) {
                                        SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, vpdFile);
                                        sdrRB.addRequest(sdr);
                                    } else {
                                        vpdFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                                        sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD xmlResults.length was zero");
                                    }
                                } else {
                                    vpdFileInfo.fileName = fileName + "\nFile length was zero.";
                                    sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile length was 0");
                                }
                            } else {
                                vpdFileInfo.fileName = fileName + "\nFile not found.";
                                sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile was null");
                            }
                            fileName = "Heartbeat Information";
                            ServiceAgentAttr.ESAsdrFileInfo hBeatFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
                            sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                            String reportingSystem = ServiceAgentUtils.getLocalCredential();
                            if (reportingSystem != null && reportingSystem.length() > 0) {
                                String xmlResults = ServiceAgentUtils.ESAHealthCheckRequest(false, reportingSystem, Integer.toString(ServiceAgentUtils.getExecutionFrequency()), state);
                                if (xmlResults.length() > 0) {
                                    SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, null);
                                    sdrRB.addRequest(sdr);
                                } else {
                                    hBeatFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                                    sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Heartbeat xmlResults.length was zero");
                                }
                            } else {
                                hBeatFileInfo.fileName = fileName + "\nUnable to generate local credential.";
                                sdrRequest.sdrFiles.put("Heartbeat", hBeatFileInfo);
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] localCredential not set");
                            }
                            if (sdrRB.getRequestList().size() > 0) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] issue SdrSubmit: " + requestType);
                                sdrRB.setUserAttachement(sdrRequest);
                                rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", eventType);
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no data for SdrSubmit");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid machType machModel");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] type_model or serial_num were null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] could not find key: name");
            }
        }
        return rc;
    }

    public static int XmitVPD(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitEndOfCall");
        int rc = 0;
        String fileName = "";
        ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
        sdrRequest.requestType = "Xmit_VPD";
        sdrRequest.sdrFiles = new HashMap();
        SdrRequestBody sdrRB = new SdrRequestBody();
        sdrRB.setReportingMachineInfo(new RsfMachineInfo(machType, machModel, machSerial));
        fileName = "/var/adm/invscout/" + machType + "-" + machModel + "_" + machSerial + ".VPD.xml";
        ServiceAgentAttr.ESAsdrFileInfo vpdFileInfo = new ServiceAgentAttr.ESAsdrFileInfo(fileName, fileName, false);
        sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] VPD output file: " + fileName);
        rc = ServiceAgentUtils.collectVpdFromMtms(machType, machModel, machSerial);
        File vpdFile = new File(fileName);
        if (vpdFile != null) {
            if (vpdFile.length() > 0L) {
                String xmlResults = ServiceAgentUtils.ESAInventoryRequest(false, machType, machModel, machSerial, vpdFile);
                if (xmlResults.length() > 0) {
                    SdrHttpRequest sdr = new SdrHttpRequest(xmlResults, vpdFile);
                    sdrRB.addRequest(sdr);
                } else {
                    vpdFileInfo.fileName = fileName + "\nUnable to generate SDR request.";
                    sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                }
            } else {
                vpdFileInfo.fileName = fileName + "\nFile length was zero.";
                sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile length was 0");
            }
        } else {
            vpdFileInfo.fileName = fileName + "\nFile not found.";
            sdrRequest.sdrFiles.put("VPD", vpdFileInfo);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] vpdFile was null");
        }
        if (sdrRB.getRequestList().size() > 0) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] issue SdrSubmit: SaVPDReq");
            sdrRB.setUserAttachement(sdrRequest);
            rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", "SaVPDReq");
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no data for SdrSubmit");
        }
        return rc;
    }

    public static int XmitPM(String requestType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] XmitPM");
        String eventType = "SaAixPmReqI";
        if (requestType.equals("Xmit_PM_Scheduled")) {
            eventType = "SaAixPmReqS";
        }
        int rc = 0;
        Map[] mapArray = ServiceAgentUtils.getSystemInfo();
        if (mapArray != null) {
            for (int i = 0; i < mapArray.length; ++i) {
                Map tmpMap = mapArray[i];
                String name = (String)tmpMap.get("name");
                if (name != null) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] working with system: " + name);
                    String type_model = (String)tmpMap.get("type_model");
                    String serial_num = (String)tmpMap.get("serial_num");
                    String state = (String)tmpMap.get("state");
                    String sp_version = (String)tmpMap.get("sp_version");
                    if (type_model != null && serial_num != null) {
                        String[] mtypemodel = type_model.split("-|_");
                        if (mtypemodel.length == 2) {
                            Map[] partitionArray = ServiceAgentUtils.getPartitionInfo(mtypemodel[0], mtypemodel[1], serial_num);
                            if (partitionArray != null) {
                                for (int count = 0; count < partitionArray.length; ++count) {
                                    String lparID = (String)partitionArray[count].get("lparID");
                                    String hostName = (String)partitionArray[count].get("hostName");
                                    String ipAddress = (String)partitionArray[count].get("ipAddress");
                                    String active = (String)partitionArray[count].get("active");
                                    String osType = (String)partitionArray[count].get("osType");
                                    String osLevel = (String)partitionArray[count].get("osLevel");
                                    if (!active.equals(AIXPM_DATATYPE_NETWORKSTAT) || !osType.equals("AIX")) continue;
                                    String rmcRC = "";
                                    String pmRC = "";
                                    String pmPath = "";
                                    String pmErrorMsg = "";
                                    String fileName = "";
                                    Object results = null;
                                    Object pmFile = null;
                                    Object pmFileInfo = null;
                                    ServiceAgentAttr.ESAsdrRequest sdrRequest = new ServiceAgentAttr.ESAsdrRequest();
                                    sdrRequest.requestType = requestType;
                                    sdrRequest.sdrFiles = new HashMap();
                                    SdrRequestBody sdrRB = new SdrRequestBody();
                                    sdrRB.setReportingMachineInfo(new RsfMachineInfo(mtypemodel[0], mtypemodel[1], serial_num));
                                    SdrHttpRequest sdr = null;
                                    sdr = ServiceAgentUtils.buildSdrPmAixRequest(mtypemodel[0], mtypemodel[1], serial_num, lparID, SAAIXPM_DATATYPE_DISKUSAGESTAT, AIXPM_DATATYPE_DISKUSAGESTAT, "Disk usage", eventType, sdrRequest);
                                    if (sdr != null) {
                                        sdrRB.addRequest(sdr);
                                    }
                                    if ((sdr = ServiceAgentUtils.buildSdrPmAixRequest(mtypemodel[0], mtypemodel[1], serial_num, lparID, SAAIXPM_DATATYPE_ENVIRONMENTSTAT, AIXPM_DATATYPE_ENVIRONMENTSTAT, "Environment", eventType, sdrRequest)) != null) {
                                        sdrRB.addRequest(sdr);
                                    }
                                    if ((sdr = ServiceAgentUtils.buildSdrPmAixRequest(mtypemodel[0], mtypemodel[1], serial_num, lparID, SAAIXPM_DATATYPE_IOSTAT, AIXPM_DATATYPE_IOSTAT, "IO", eventType, sdrRequest)) != null) {
                                        sdrRB.addRequest(sdr);
                                    }
                                    if ((sdr = ServiceAgentUtils.buildSdrPmAixRequest(mtypemodel[0], mtypemodel[1], serial_num, lparID, SAAIXPM_DATATYPE_NETWORKSTAT, AIXPM_DATATYPE_NETWORKSTAT, "Network", eventType, sdrRequest)) != null) {
                                        sdrRB.addRequest(sdr);
                                    }
                                    if ((sdr = ServiceAgentUtils.buildSdrPmAixRequest(mtypemodel[0], mtypemodel[1], serial_num, lparID, SAAIXPM_DATATYPE_STATS, AIXPM_DATATYPE_STATS, "Stats", eventType, sdrRequest)) != null) {
                                        sdrRB.addRequest(sdr);
                                    }
                                    if (sdrRB.getRequestList() != null && sdrRB.getRequestList().size() > 0) {
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] issue SdrSubmit: " + eventType);
                                        sdrRB.setUserAttachement(sdrRequest);
                                        rc = ServiceAgentUtils.SdrSubmit(sdrRB, "ESA.xmit.service", eventType);
                                        continue;
                                    }
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no data for SdrSubmit");
                                }
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] partitionArray was null");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] invalid machType machModel");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] type_model or serial_num were null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] could not find key: name");
            }
        }
        return rc;
    }

    public static SdrHttpRequest buildSdrPmAixRequest(String machType, String machModel, String machSerial, String lparID, String saPmAixOption, String saPmAixdataType, String sdrFileType, String eventType, ServiceAgentAttr.ESAsdrRequest sdrRequest) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] buildSdrPmAixRequest");
        String rmcRC = "";
        String pmRC = "";
        String pmPath = "";
        String pmErrorMsg = "";
        Map results = null;
        File pmFile = null;
        ServiceAgentAttr.ESAsdrFileInfo pmFileInfo = null;
        SdrHttpRequest sdr = null;
        pmFileInfo = new ServiceAgentAttr.ESAsdrFileInfo("", "", false);
        sdrRequest.sdrFiles.put(sdrFileType, pmFileInfo);
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sdrFileType: " + sdrFileType);
        results = ServiceAgentUtils.runSaPmAix(machType, machModel, machSerial, lparID, saPmAixOption);
        if (results != null) {
            rmcRC = (String)results.get(RUNPMAIX_rmcRC);
            pmRC = (String)results.get(RUNPMAIX_pmRC);
            pmPath = (String)results.get(RUNPMAIX_pmPath);
            pmErrorMsg = (String)results.get(RUNPMAIX_pmErrorMsg);
            pmPath = pmPath.replaceAll("\"", " ");
            pmPath = pmPath.trim();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rmcRC: " + rmcRC);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmRC: " + pmRC);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmPath: " + pmPath);
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmErrorMsg: " + pmErrorMsg);
            if (rmcRC.equals("0") && pmRC.equals("0")) {
                pmFile = new File(pmPath);
                if (pmFile != null) {
                    if (pmFile.length() > 0L) {
                        String xmlResults = ServiceAgentUtils.aixPMrequest(false, machType, machModel, machSerial, pmFile, saPmAixdataType, eventType);
                        if (xmlResults.length() > 0) {
                            pmFileInfo.fileName = pmPath;
                            pmFileInfo.originalFileName = pmPath;
                            sdrRequest.sdrFiles.put(sdrFileType, pmFileInfo);
                            sdr = new SdrHttpRequest(xmlResults, pmFile);
                        } else {
                            pmFileInfo.fileName = pmPath + "\nUnable to generate SDR request.";
                            sdrRequest.sdrFiles.put(sdrFileType, pmFileInfo);
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PM xmlResults.length was zero");
                        }
                    } else {
                        pmFileInfo.fileName = pmFile + "\nFile length was zero.";
                        sdrRequest.sdrFiles.put(sdrFileType, pmFileInfo);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmFile.length was 0");
                    }
                } else {
                    pmFileInfo.fileName = pmPath + "\nFile not found.";
                    sdrRequest.sdrFiles.put(sdrFileType, pmFileInfo);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmFile was null");
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] results was null");
        }
        return sdr;
    }

    public static Map runSaPmAix(String machType, String machModel, String machSerial, String laprID, String dataType) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] runSaPmAix");
        int rc = 0;
        String[] sysArray = null;
        HashMap<String, String> mapArray = null;
        try {
            Process pid = RootProcess.startProgram("saPmAix " + machType + " " + machModel + " " + machSerial + " " + laprID + " " + dataType);
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] saPmAix buffer: " + buffer);
                    if (buffer.length() > 0) {
                        sysArray = (buffer = buffer.trim()).split("::");
                        if (sysArray != null) {
                            if (sysArray.length >= 4) {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] rmcRC: " + sysArray[0].trim());
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmRC: " + sysArray[1].trim());
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmPath: " + sysArray[2].trim());
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pmErrorMsg: " + sysArray[3].trim());
                                mapArray = new HashMap<String, String>(4);
                                mapArray.put(RUNPMAIX_rmcRC, sysArray[0].trim());
                                mapArray.put(RUNPMAIX_pmRC, sysArray[1].trim());
                                mapArray.put(RUNPMAIX_pmPath, sysArray[2].trim());
                                mapArray.put(RUNPMAIX_pmErrorMsg, sysArray[3].trim());
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray.length was not equal to 4");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray was null");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return mapArray;
    }

    public static Map[] getSystemInfo() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getSystemInfo");
        int rc = 0;
        String[] sysArray = null;
        Map[] mapArray = null;
        try {
            Process pid = RootProcess.startProgram("lsSYSCFG -r sys");
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsSYSCFG buffer: " + buffer);
                    if (buffer.length() > 0) {
                        buffer = buffer.trim();
                        sysArray = (buffer = buffer.replace('\n', ';')).split(delim);
                        if (sysArray != null) {
                            if (sysArray.length > 0) {
                                if (sysArray[0].indexOf("name=") >= 0) {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] number of elements: " + sysArray.length);
                                    ArrayList tmpArray = new ArrayList();
                                    for (int i = 0; i < sysArray.length; ++i) {
                                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray[" + i + "] = " + sysArray[i]);
                                        StringTokenizer st = new StringTokenizer(sysArray[i], ",");
                                        int reps = st.countTokens();
                                        HashMap<String, String> tmpMap = new HashMap<String, String>();
                                        for (int j = 0; j < reps; ++j) {
                                            String[] tmpValue = st.nextToken().split("=");
                                            if (tmpValue != null && tmpValue.length == 2) {
                                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] key[" + tmpValue[0].trim() + "] value[" + tmpValue[1].trim() + "]");
                                                tmpMap.put(tmpValue[0].trim(), tmpValue[1].trim());
                                                continue;
                                            }
                                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] tmpValue not set properly");
                                        }
                                        if (tmpMap.size() <= 0) continue;
                                        tmpArray.add(tmpMap);
                                    }
                                    if (tmpArray.size() > 0) {
                                        mapArray = tmpArray.toArray(new Map[tmpArray.size()]);
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] data not set: " + sysArray[0]);
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray.length was 0");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray was null");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return mapArray;
    }

    public static Map[] getPartitionInfo(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getPartitionInfo");
        int rc = 0;
        String[] sysArray = null;
        Map[] mapArray = null;
        try {
            Process pid = RootProcess.startProgram("lsPARTITION -c " + machType + "-" + machModel + "_" + machSerial + " -ix");
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsPARTITION buffer: " + buffer);
                    if (buffer.length() > 0) {
                        sysArray = (buffer = buffer.trim()).split(delim);
                        if (sysArray != null) {
                            if (sysArray.length > 0) {
                                ArrayList tmpArray = new ArrayList();
                                for (int i = 0; i < sysArray.length; ++i) {
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray[" + i + "] = " + sysArray[i]);
                                    String[] parmsArray = sysArray[i].split(":");
                                    if (parmsArray.length >= 6) {
                                        HashMap<String, String> tmpMap = new HashMap<String, String>(6);
                                        tmpMap.put("lparID", parmsArray[0]);
                                        tmpMap.put("ipAddress", parmsArray[1]);
                                        tmpMap.put("active", parmsArray[2]);
                                        tmpMap.put("hostName", parmsArray[3]);
                                        tmpMap.put("osType", parmsArray[4]);
                                        tmpMap.put("osLevel", parmsArray[5]);
                                        tmpArray.add(tmpMap);
                                        continue;
                                    }
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] missing parms");
                                }
                                if (tmpArray.size() > 0) {
                                    mapArray = tmpArray.toArray(new Map[tmpArray.size()]);
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray.length was 0");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sysArray was null");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return mapArray;
    }

    public static String getCodInfo(String machType, String machModel, String machSerial, String parm) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getCodInfo");
        int rc = 0;
        String billInfo = null;
        try {
            Process pid = RootProcess.startProgram("lsCOD -t bill -m " + machType + "-" + machModel + "*" + machSerial + " -r " + parm);
            if (pid != null) {
                InputStream ips = pid.getInputStream();
                rc = pid.waitFor();
                byte[] b = new byte[255];
                String buffer = "";
                if (ips != null) {
                    int bytesRead = ips.read(b);
                    while (bytesRead > 0) {
                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                        bytesRead = ips.read(b);
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] lsCOD buffer: " + buffer);
                    if (buffer.length() > 0) {
                        billInfo = buffer.trim();
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] buffer was empty");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        return billInfo;
    }

    public static int closeProblemEvents(PIProblem theProblem) {
        Object event;
        int idx;
        List secDataEvents;
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] closeProblemEvents");
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, "SaCloseSael", null, null, null, null);
        theLog.add((byte)3, theProblem.toString());
        int rc = 0;
        ArrayList<CommonDataEvent> dataEvents = new ArrayList<CommonDataEvent>();
        CommonDataEvent dataEvent = theProblem.getPrimaryDataEvent();
        if (dataEvent != null && dataEvent instanceof SaelDataEvent) {
            dataEvents.add(dataEvent);
        }
        if ((secDataEvents = theProblem.getSecondaryDataEventList()) != null) {
            for (idx = 0; idx < secDataEvents.size(); ++idx) {
                event = secDataEvents.get(idx);
                if (!(event instanceof SaelDataEvent)) continue;
                dataEvents.add((CommonDataEvent)event);
            }
        }
        if (dataEvents.size() > 0) {
            for (idx = 0; idx < dataEvents.size(); ++idx) {
                event = dataEvents.get(idx);
                PASystem system = null;
                if (!(event instanceof SaelDataEvent)) continue;
                SaelDataEvent saelEvent = (SaelDataEvent)event;
                system = saelEvent.getFailingEnclosureSystem();
                if (system != null) {
                    try {
                        String parmsToInvokeWith = "IBM.Sfp::::updateStatus::Action::\"Closed\"::MTypeModel::\"" + system.getMachineType() + "-" + system.getMachineModel() + "\"::MSerial::\"" + system.getMachineSerial() + "\"::PartitionID::\"" + saelEvent.getPartitionID() + "\"::ErrLogSeqNum::" + Long.toString(saelEvent.getSeqNum()) + "::PlatformLogID::" + Integer.toString(saelEvent.getPlatformLogID()) + "::ErrLogLabel::\"" + saelEvent.getErrorLogLabel() + "\"";
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] close SAEL event: " + parmsToInvokeWith);
                        block = (byte)(block + 1);
                        theLog.add(block, parmsToInvokeWith);
                        String[] cmdArray = new String[]{"runact-api", "-c", parmsToInvokeWith};
                        Process pid = RootProcess.startProgram(cmdArray);
                        if (pid != null) {
                            InputStream ips = pid.getInputStream();
                            rc = pid.waitFor();
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] runact-api rc: " + rc);
                            if (rc == 0) {
                                byte[] b = new byte[255];
                                String buffer = "";
                                if (ips != null) {
                                    int bytesRead = ips.read(b);
                                    while (bytesRead > 0) {
                                        buffer = buffer + new String(b, 0, bytesRead, "US-ASCII");
                                        bytesRead = ips.read(b);
                                    }
                                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] runact-api buffer: " + buffer);
                                    buffer = buffer.trim();
                                    String result = "";
                                    result = buffer.endsWith("0") ? "Success -> " : (buffer.endsWith("22") ? "Invalid number of input parms -> " : (buffer.endsWith("24") ? "Matching SAEL was not found -> " : "Unknown result -> "));
                                    block = (byte)(block + 1);
                                    theLog.add(block, result + buffer);
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ips was null");
                                block = (byte)(block + 1);
                                theLog.add(block, "ips was null");
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] non-zero rc from runact-api: " + rc);
                            block = (byte)(block + 1);
                            theLog.add(block, "non-zero rc from runact-api: " + rc);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] pid was null");
                        block = (byte)(block + 1);
                        theLog.add(block, "pid was null");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got an exception");
                        Trace.trace(TRACE_MASKF, e);
                    }
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] PASystem was null");
                block = (byte)(block + 1);
                theLog.add(block, "PASystem was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] No SAEL events to process");
            block = (byte)(block + 1);
            theLog.add(block, "No SAEL events to process");
        }
        theLog.log();
        return rc;
    }

    public static String getCecCredential(String machType, String machModel, String machSerial) {
        String cecCredential;
        block9: {
            Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getCecCredential");
            boolean rc = false;
            cecCredential = null;
            CredentialStore cstore = PICredentials.getCredentialStore();
            String Mtms = machType + "-" + machModel + "*" + machSerial;
            if (cstore != null) {
                try {
                    SysInfo credential = CredentialUtils.getCredentials(Mtms, cstore);
                    if (credential == null) {
                        CredentialResult result = CredentialUtils.getNewCredentialsSynchronous(Mtms, cstore);
                        if (result != null) {
                            credential = result.getCredentials();
                            if (credential != null) {
                                cecCredential = credential.getMachineId();
                            } else {
                                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] credential was null");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] result was null");
                        }
                        break block9;
                    }
                    cecCredential = credential.getMachineId();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] getCredentials exception");
                    Trace.trace(TRACE_MASKF, CLASS_NAME + e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] cstore was null");
            }
        }
        return cecCredential;
    }

    public static String getLocalCredential() {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] getLocalCredential");
        boolean rc = false;
        String localCredential = null;
        try {
            SysInfo credential = CredentialUtils.getLocalCredentials();
            if (credential == null) {
                CredentialResult result = CredentialUtils.getNewLocalCredentialsSynchronous();
                if (result != null) {
                    credential = result.getCredentials();
                    if (credential != null) {
                        localCredential = credential.getMachineId();
                    } else {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] credential was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] result was null");
                }
            } else {
                localCredential = credential.getMachineId();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] getLocalCredentials exception");
            Trace.trace(TRACE_MASKF, CLASS_NAME + e);
        }
        return localCredential;
    }

    public static ServiceAgentAttr.ESAreportingMachInfo getReportingMachineInfo(PIProblem theProblem) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> getReportingMachineInfo");
        ServiceAgentAttr.ESAreportingMachInfo rep = new ServiceAgentAttr.ESAreportingMachInfo();
        if (theProblem.getReportingRemoteMachineSystem() != null) {
            rep.machType = theProblem.getReportingRemoteMachineSystem().getMachineType();
            rep.machModel = theProblem.getReportingRemoteMachineSystem().getMachineModel();
            rep.machSerial = theProblem.getReportingRemoteMachineSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used ReportingRemoteMachineSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        } else if (theProblem.getFailingSystem() != null) {
            rep.machType = theProblem.getFailingSystem().getMachineType();
            rep.machModel = theProblem.getFailingSystem().getMachineModel();
            rep.machSerial = theProblem.getFailingSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used FailingSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        } else if (theProblem.getPrimaryAnalyzingConsoleSystem() != null) {
            rep.machType = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineType();
            rep.machModel = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineModel();
            rep.machSerial = theProblem.getPrimaryAnalyzingConsoleSystem().getMachineSerial();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] used PrimaryAnalyzingConsoleSystem for ReportingMachineInfo[" + rep.machType + rep.machModel + rep.machSerial + "]");
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <- getReportingMachineInfo");
        return rep;
    }

    public static void scheduleXmitVPD(String machType, String machModel, String machSerial) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> scheduleXmitVPD");
        String sParm = "XmitVPD " + machType + " " + machModel + " " + machSerial;
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] ScheduledOperation options: " + sParm);
        ServiceAgentAttr.ESAbatchXmitVPD xmitVPD = new ServiceAgentAttr.ESAbatchXmitVPD(machType, machModel, machSerial);
        try {
            HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
            HMC target = HMC.getHMC();
            List listOfScheduledOps = scheduler.getScheduledOperations(target, operation);
            boolean sendit = true;
            if (listOfScheduledOps != null) {
                for (int ix = 0; ix < listOfScheduledOps.size(); ++ix) {
                    ScheduledOperation so = (ScheduledOperation)listOfScheduledOps.get(ix);
                    Object xmitParms = so.getOperationParameters();
                    if (xmitParms != null) {
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sched objname: " + xmitParms.getClass().getName());
                        if (!xmitVPD.equals(xmitParms)) continue;
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Xmit VPD already scheduled: " + sParm);
                        sendit = false;
                        break;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] no parms");
                }
            }
            if (sendit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Schedule Xmit VPD: " + sParm);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                String datetime = "";
                Date date = new Date();
                datetime = df.format(date);
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] current datetime: " + datetime);
                date.setTime(date.getTime() + 86400000L);
                datetime = df.format(date);
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] scheduled datetime: " + datetime);
                Schedule schedule = new Schedule(date, 1200000L, 1L, 0L);
                ESAXmitServiceInfoSchedulable newOperation = new ESAXmitServiceInfoSchedulable();
                ScheduledOperation schedop = new ScheduledOperation(target, newOperation, schedule, xmitVPD);
                target.getScheduler().addScheduledOperation(schedop);
            }
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] caught exception:");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <-- scheduleXmitVPD");
    }

    public static int scheduleXmitEED(ServiceAgentAttr.ESAbatchEEDrequest eedRequest) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> scheduleXmitEED");
        String passiveMode = ServiceAgentUtils.getFtpServerPassiveMode();
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> passive mode: " + passiveMode);
        int rc = 0;
        try {
            Calendar now = Calendar.getInstance();
            Schedule schedule = new Schedule(now.getTime(), 1200000L, 1L, 1L);
            HMC target = HMC.getHMC();
            ESAXmitServiceInfoSchedulable newOperation = new ESAXmitServiceInfoSchedulable();
            ScheduledOperation schedop = new ScheduledOperation(target, newOperation, schedule, eedRequest);
            target.getScheduler().addScheduledOperation(schedop);
        }
        catch (Throwable t) {
            rc = 1;
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] caught exception:");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <-- scheduleXmitEED");
        return rc;
    }

    public static int scheduleXmitPMImmed(ServiceAgentAttr.ESAbatchXmitPMImmed batchXmitPMImmed) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> scheduleXmitPMImmed");
        int rc = 0;
        try {
            Calendar now = Calendar.getInstance();
            Schedule schedule = new Schedule(now.getTime(), 1200000L, 1L, 1L);
            HMC target = HMC.getHMC();
            ESAXmitServiceInfoSchedulable newOperation = new ESAXmitServiceInfoSchedulable();
            ScheduledOperation schedop = new ScheduledOperation(target, newOperation, schedule, batchXmitPMImmed);
            target.getScheduler().addScheduledOperation(schedop);
        }
        catch (Throwable t) {
            rc = 1;
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] caught exception:");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <-- scheduleXmitPMImmed");
        return rc;
    }

    public static int scheduleXmitPMSched(ServiceAgentAttr.ESAbatchXmitPMSched batchXmitPMSched) {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> scheduleXmitPMSched");
        int rc = 0;
        try {
            Calendar now = Calendar.getInstance();
            Schedule schedule = new Schedule(now.getTime(), 1200000L, -1L, 86400000L);
            HMC target = HMC.getHMC();
            ESAXmitServiceInfoSchedulable newOperation = new ESAXmitServiceInfoSchedulable();
            ScheduledOperation schedop = new ScheduledOperation(target, newOperation, schedule, batchXmitPMSched);
            target.getScheduler().addScheduledOperation(schedop);
        }
        catch (Throwable t) {
            rc = 1;
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] caught exception:");
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <-- scheduleXmitPMSched");
        return rc;
    }

    public static String getHmcType() {
        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] --> getHmcType");
        String hmcType = "";
        Properties hmcProperties = new Properties();
        try {
            FileInputStream in = new FileInputStream(hmcTypeFile);
            hmcProperties.load(in);
            if (hmcProperties.size() > 0) {
                hmcType = hmcProperties.getProperty("HMCTYPE", "ipHMC");
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] hmcType: " + hmcType);
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] zero entries in file: /opt/hsc/data/hmcType.properties");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] error loading file: /opt/hsc/data/hmcType.properties");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <-- getHmcType");
        return hmcType;
    }

    public static File processDump(File theDump, int callHomeLimit) {
        File newFile = theDump;
        if (theDump.exists()) {
            if (theDump.length() > (long)callHomeLimit) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] theDump.length: " + theDump.length());
                int fileEntrySize = 0;
                boolean dumpHeaderSize = false;
                long totalDumpSize = 0L;
                long totalBytesCopied = 0L;
                TreeMap<sectionInfo, Integer> sMap = new TreeMap<sectionInfo, Integer>(PRIORITY_ORDER);
                try {
                    Integer section;
                    sectionInfo si;
                    Map.Entry e;
                    int count;
                    Map.Entry e2;
                    FileInputStream fis = new FileInputStream(theDump);
                    byte[] data = new byte[100];
                    int bytesRead = fis.read(data, 0, 64);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] header: ");
                    Trace.trace(TRACE_MASKF, data);
                    fileEntrySize = ByteArray.extractU16(data, 8, false);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the end if the file directory is at: " + fileEntrySize);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] read in the first section:");
                    bytesRead = fis.read(data, 0, 32);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] section: " + data);
                    Trace.trace(TRACE_MASKF, data);
                    boolean atEndOfDirectory = false;
                    int sectionNumber = 1;
                    while (!atEndOfDirectory) {
                        sectionInfo si2 = new sectionInfo();
                        si2.section = sectionNumber;
                        si2.entrySize = ByteArray.extractU16(data, 8, false);
                        si2.priority = ByteArray.extractU16(data, 10, false);
                        si2.size = ServiceAgentUtils.extractU64(data, 24, false);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]         section: " + si2.section);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       entrySize: " + si2.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] sectionPriority: " + si2.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]     sectionSize: " + si2.size);
                        sMap.put(si2, new Integer(sectionNumber));
                        ++sectionNumber;
                        long lastSectionFlag = ByteArray.extractU32(data, 16, false);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section data is " + lastSectionFlag);
                        if ((lastSectionFlag & 1L) > 0L) {
                            atEndOfDirectory = true;
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section is true");
                        } else {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] last section is false");
                        }
                        int bytesToRead = si2.entrySize - 32;
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] bytes to read are " + bytesToRead);
                        int remainder = fis.read(data, 0, bytesToRead);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the remainder data is:");
                        Trace.trace(TRACE_MASKF, data);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] read the next header:");
                        if (!atEndOfDirectory) {
                            fis.read(data, 0, 32);
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] the next header: " + data);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] at the end don't read the next chunk");
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] we are at the end of the directory entires");
                    fis.close();
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] fileEntrySize: " + fileEntrySize);
                    int totalBytes = fileEntrySize;
                    Iterator i = sMap.entrySet().iterator();
                    while (i.hasNext()) {
                        e2 = i.next();
                        sectionInfo si3 = (sectionInfo)e2.getKey();
                        Integer section2 = (Integer)e2.getValue();
                        totalBytes += si3.entrySize;
                    }
                    i = sMap.entrySet().iterator();
                    while (i.hasNext()) {
                        e2 = i.next();
                        sectionInfo si4 = (sectionInfo)e2.getKey();
                        Integer section3 = (Integer)e2.getValue();
                        if ((long)totalBytes + si4.size <= (long)callHomeLimit) {
                            si4.add = true;
                            totalBytes = (int)((long)totalBytes + si4.size);
                        } else {
                            si4.add = false;
                        }
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       section: " + section3);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]     entrySize: " + si4.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]      priority: " + si4.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]          size: " + si4.size);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]           add: " + si4.add);
                    }
                    fis = new FileInputStream(theDump);
                    int numBytes = 0;
                    byte[] cdata = new byte[4096];
                    String fileLocation = BaseFileControl.getFilePath(ESA_PATH) + theDump.getName();
                    FileOutputStream fos = new FileOutputStream(fileLocation);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, cdata.length);
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] copying fileDirectorySection: " + fileEntrySize);
                    int bytesToCopy = fileEntrySize;
                    for (int wrkBytes = 0; wrkBytes < bytesToCopy; wrkBytes += count) {
                        numBytes = (bytesToCopy - wrkBytes) / cdata.length > 0 ? cdata.length : (bytesToCopy - wrkBytes) % cdata.length;
                        count = fis.read(cdata, 0, numBytes);
                        dest.write(cdata, 0, count);
                    }
                    totalBytesCopied += (long)fileEntrySize;
                    TreeMap<sectionInfo, Integer> sectionMap = new TreeMap<sectionInfo, Integer>(SECTION_ORDER);
                    sectionMap.putAll(sMap);
                    Iterator i2 = sectionMap.entrySet().iterator();
                    while (i2.hasNext()) {
                        e = i2.next();
                        si = (sectionInfo)e.getKey();
                        section = (Integer)e.getValue();
                        int count2 = fis.read(cdata, 0, si.entrySize);
                        if (!si.add) {
                            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] zero size in section: " + section);
                            Arrays.fill(cdata, 24, 32, (byte)0);
                        }
                        dest.write(cdata, 0, count2);
                        totalBytesCopied += (long)si.entrySize;
                    }
                    i2 = sectionMap.entrySet().iterator();
                    while (i2.hasNext()) {
                        int count3;
                        e = i2.next();
                        si = (sectionInfo)e.getKey();
                        section = (Integer)e.getValue();
                        if (!si.add) continue;
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] copying section: " + section);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]       entrySize: " + si.entrySize);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]        priority: " + si.priority);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]            size: " + si.size);
                        Trace.trace(TRACE_MASKF, "[ServiceAgentUtils]             add: " + si.add);
                        bytesToCopy = (int)si.size;
                        for (int wrkBytes = 0; wrkBytes < bytesToCopy; wrkBytes += count3) {
                            numBytes = (bytesToCopy - wrkBytes) / cdata.length > 0 ? cdata.length : (bytesToCopy - wrkBytes) % cdata.length;
                            count3 = fis.read(cdata, 0, numBytes);
                            dest.write(cdata, 0, count3);
                        }
                        totalBytesCopied += si.size;
                    }
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] totalBytesCopied: " + totalBytesCopied);
                    dest.flush();
                    dest.close();
                    fos.close();
                    fis.close();
                    newFile = new File(fileLocation);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got exeception read the file");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] file under limit: " + theDump.getPath());
                newFile = theDump;
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] file does not exist: " + theDump.getPath());
        }
        return newFile;
    }

    public static boolean isOEM() {
        boolean result;
        boolean bl = result = !new File(IBM_SERVICE_FILE).exists();
        if (result) {
            Trace.trace(TRACE_MASKF, "OEM environment");
        } else {
            Trace.trace(TRACE_MASKF, "IBM environment");
        }
        return result;
    }

    public static int buildZipFile(String outputZipFile, ArrayList files, boolean remove) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> buildZipFile");
        int rc = 0;
        int BUFFER = 4096;
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(outputZipFile);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[BUFFER];
            for (int i = 0; i < files.size(); ++i) {
                int count;
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Adding: " + (String)files.get(i));
                FileInputStream fi = new FileInputStream((String)files.get(i));
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry((String)files.get(i));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                if (!remove) continue;
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] delete file: " + (String)files.get(i));
                File delFile = new File((String)files.get(i));
                if (delFile != null) {
                    delFile.delete();
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] delFile was null");
            }
            out.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] got exeception building zip");
            Trace.trace(TRACE_MASKF, e);
        }
        return rc;
    }

    public static Object notifyOEM(String eventType, Object parms) {
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] -> notifyOEM(" + parms + ")");
        if (OEMProblemDir == null) {
            try {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Find the OEM problem description directory");
                OEMProblemDir = BaseFileControl.getFilePath(DFC_OEM_PROBLEM_DIR);
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] DFC lookup for oemproblemdir failed");
            }
        }
        HMC hmc = HMC.getHMC();
        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
        String hmcName = hmc.getDisplayableName().toString();
        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
            hmcName = networkInfo.getComputerName() + "." + networkInfo.getDomainName();
        }
        String problemDescriptionFile = "";
        BufferedWriter w = null;
        try {
            if (eventType.equals("DumpCallHome")) {
                ServiceAgentAttr.OEMeedOnlyInfo eedInfo = (ServiceAgentAttr.OEMeedOnlyInfo)parms;
                String FileName = eedInfo.eedFileLocation;
                FileName = FileName.replaceAll("/", ".");
                FileName = FileName.replaceAll("-", ".");
                problemDescriptionFile = OEMProblemDir + eventType + FileName + ".dat";
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(problemDescriptionFile), "UTF-8"));
                ServiceAgentUtils.writeString(w, "EventType", eventType);
                ServiceAgentUtils.writeString(w, "FDMachineType", eedInfo.machineType);
                ServiceAgentUtils.writeString(w, "FDMachineModel", eedInfo.machineModel);
                ServiceAgentUtils.writeString(w, "FDMachineSerial", eedInfo.machineSerial);
                ServiceAgentUtils.writeBoolean(w, "EverCallHome", true);
                ServiceAgentUtils.writeString(w, "HSCId", hmc.getMachineType() + hmc.getMachineModel());
                ServiceAgentUtils.writeString(w, "HSCName", hmc.getMachineSerial());
                ServiceAgentUtils.writeString(w, "HMCNameContainingDumpFile", hmcName);
                ServiceAgentUtils.writeString(w, "DumpID", eedInfo.eedFileLocation);
            } else {
                List problemDataDescriptors;
                String temp;
                CommonProblem p = (CommonProblem)parms;
                problemDescriptionFile = OEMProblemDir + eventType + "." + p.getProblemNumber() + ".dat";
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(problemDescriptionFile), "UTF-8"));
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] About to write Problem description file: " + problemDescriptionFile);
                CommonDataEvent primaryDataEvent = p.getPrimaryDataEvent();
                SaelDataEvent sael = null;
                PelDataEvent pel = null;
                if (primaryDataEvent != null) {
                    if (primaryDataEvent instanceof SaelDataEvent) {
                        sael = (SaelDataEvent)primaryDataEvent;
                    } else if (primaryDataEvent instanceof PelDataEvent) {
                        pel = (PelDataEvent)primaryDataEvent;
                    }
                }
                ServiceAgentUtils.writeString(w, "EventType", eventType);
                PASystem system = p.getFailingSystem();
                if (system != null) {
                    ServiceAgentUtils.writeString(w, "FDMachineType", system.getMachineType());
                    ServiceAgentUtils.writeString(w, "FDMachineModel", system.getMachineModel());
                    ServiceAgentUtils.writeString(w, "FDMachineSerial", system.getMachineSerial());
                } else {
                    ServiceAgentUtils.writeString(w, "FDMachineType", "");
                    ServiceAgentUtils.writeString(w, "FDMachineModel", "");
                    ServiceAgentUtils.writeString(w, "FDMachineSerial", "");
                }
                ServiceAgentUtils.writeNumeric(w, "ProblemNumber", p.getProblemNumber());
                ServiceAgentUtils.writeString(w, "RefCode", p.getRefcode());
                ServiceAgentUtils.writeNumeric(w, "DuplicateCount", p.getDuplicateCount());
                ServiceAgentUtils.writeTimestamp(w, "OriginalTimeStamp", p.getFirstReportedTimestamp());
                ServiceAgentUtils.writeTimestamp(w, "LastReportedTimeStamp", p.getLastReportedTimestamp());
                ServiceAgentUtils.writeTimestamp(w, "CreatedTimeStamp", p.getProblemTimeStamp());
                if (eventType.equals("ProblemCallHome")) {
                    ServiceAgentUtils.writeBoolean(w, "EverCallHome", true);
                } else {
                    ServiceAgentUtils.writeBoolean(w, "EverCallHome", p.isCallHome());
                }
                ServiceAgentUtils.writeBoolean(w, "CalledHome", p.getPMH() != null);
                system = p.getReportingRemoteMachineSystem();
                if (system != null) {
                    ServiceAgentUtils.writeString(w, "CECMachineType", system.getMachineType());
                    ServiceAgentUtils.writeString(w, "CECMachineModel", system.getMachineModel());
                    ServiceAgentUtils.writeString(w, "CECMachineSerialNumber", system.getMachineSerial());
                }
                if ((temp = p.getDescription().toString()) == null) {
                    temp = "none";
                }
                if (temp != null && temp.length() > 54) {
                    ServiceAgentUtils.writeString(w, "Description", temp.substring(0, 54));
                    ServiceAgentUtils.writeString(w, "Detail-Description", temp);
                } else {
                    ServiceAgentUtils.writeString(w, "Description", temp);
                }
                ServiceAgentUtils.writeString(w, "HSCId", hmc.getMachineType() + hmc.getMachineModel());
                ServiceAgentUtils.writeString(w, "HSCName", hmc.getMachineSerial());
                List frus = p.getParts();
                if (frus != null && frus.size() > 0) {
                    int fruCount = frus.size();
                    String[] FRUCCINs = new String[fruCount];
                    String[] FRUEnclosureMachineTypeModels = new String[fruCount];
                    String[] FRUEnclosureMachineSerialNumbers = new String[fruCount];
                    String[] FRULogicControllingCECMachineTypeModels = new String[fruCount];
                    String[] FRULogicControllingCECMachineSerialNumbers = new String[fruCount];
                    String[] FRUPowerControllingCECMachineTypeModels = new String[fruCount];
                    String[] FRUPowerControllingCECMachineSerialNumbers = new String[fruCount];
                    String[] FRUPartNumbers = new String[fruCount];
                    String[] FRUPartNumberReplaces = new String[fruCount];
                    boolean[] FRURecentlyReplaceds = new boolean[fruCount];
                    long[] FRUReplaceTimestamps = new long[fruCount];
                    String[] FRUAddLocations = new String[fruCount];
                    String[] FRUAddPartNumbers = new String[fruCount];
                    long[] FRUAddReplaceTimestamps = new long[fruCount];
                    String[] FRUClasss = new String[fruCount];
                    long[] FRUReplacementPrioritys = new long[fruCount];
                    String[] FRUConcurrentMaintenances = new String[fruCount];
                    String[] FRUDescriptions = new String[fruCount];
                    String[] FRUSerialNumbers = new String[fruCount];
                    Iterator it = frus.iterator();
                    for (int i = 0; i < fruCount; ++i) {
                        CommonPaFru fru = (CommonPaFru)it.next();
                        system = fru.getEnclosureSystem();
                        if (system != null) {
                            FRUEnclosureMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                            FRUEnclosureMachineSerialNumbers[i] = system.getMachineSerial();
                        } else {
                            FRUEnclosureMachineTypeModels[i] = null;
                            FRUEnclosureMachineSerialNumbers[i] = null;
                        }
                        FRUPartNumbers[i] = fru.getPartNumber();
                        ArrayList locations = fru.getLocationList();
                        if (locations != null) {
                            Iterator iter = locations.iterator();
                            while (iter.hasNext()) {
                                FRUPartNumbers[i] = FRUPartNumbers[i] + " " + (String)iter.next();
                            }
                        }
                        FRUPartNumberReplaces[i] = fru.getPreviousPartNumber();
                        FRURecentlyReplaceds[i] = fru.isReplacedPrior();
                        FRUReplaceTimestamps[i] = fru.getReplacedTimeStamp();
                        FRUAddLocations[i] = null;
                        FRUAddPartNumbers[i] = null;
                        FRUAddReplaceTimestamps[i] = 0L;
                        FRUConcurrentMaintenances[i] = null;
                        FRUDescriptions[i] = fru.getDescription();
                        FRUSerialNumbers[i] = fru.getSerialNumber();
                        if (!(fru instanceof PIFru)) continue;
                        PIFru pifru = (PIFru)fru;
                        FRUCCINs[i] = pifru.getCCIN();
                        system = pifru.getLogicControllingSystem();
                        if (system != null) {
                            FRULogicControllingCECMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                            FRULogicControllingCECMachineSerialNumbers[i] = system.getMachineSerial();
                        } else {
                            FRULogicControllingCECMachineTypeModels[i] = null;
                            FRULogicControllingCECMachineSerialNumbers[i] = null;
                        }
                        system = pifru.getPowerControllingSystem();
                        if (system != null) {
                            FRUPowerControllingCECMachineTypeModels[i] = system.getMachineType() + "-" + system.getMachineModel();
                            FRUPowerControllingCECMachineSerialNumbers[i] = system.getMachineSerial();
                        } else {
                            FRUPowerControllingCECMachineTypeModels[i] = null;
                            FRUPowerControllingCECMachineSerialNumbers[i] = null;
                        }
                        FRUClasss[i] = pifru.getLocalizableFruClass().toString();
                        FRUReplacementPrioritys[i] = pifru.getNumericPriority();
                    }
                    ServiceAgentUtils.writeMultiValueString(w, "FRUCCIN", FRUCCINs);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUEnclosureMachineTypeModel", FRUEnclosureMachineTypeModels);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUEnclosureMachineSerialNumber", FRUEnclosureMachineSerialNumbers);
                    ServiceAgentUtils.writeMultiValueString(w, "FRULogicControllingCECMachineTypeModel", FRULogicControllingCECMachineTypeModels);
                    ServiceAgentUtils.writeMultiValueString(w, "FRULogicControllingCECMachineSerialNumber", FRULogicControllingCECMachineSerialNumbers);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUPowerControllingCECMachineTypeModel", FRUPowerControllingCECMachineTypeModels);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUPowerControllingCECMachineSerialNumber", FRUPowerControllingCECMachineSerialNumbers);
                    ServiceAgentUtils.writeMultiLineString(w, "FRUPartNumber", FRUPartNumbers);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUPartNumberReplace", FRUPartNumberReplaces);
                    ServiceAgentUtils.writeMultiValueBoolean(w, "FRURecentlyReplaced", FRURecentlyReplaceds);
                    ServiceAgentUtils.writeMultiValueTimestamp(w, "FRUReplaceTimestamp", FRUReplaceTimestamps);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUAddLocation", FRUAddLocations);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUAddPartNumber", FRUAddPartNumbers);
                    ServiceAgentUtils.writeMultiValueTimestamp(w, "FRUAddReplaceTimestamp", FRUAddReplaceTimestamps);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUClass", FRUClasss);
                    ServiceAgentUtils.writeMultiValueNumeric(w, "FRUReplacementPriority", FRUReplacementPrioritys);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUConcurrentMaintenance", FRUConcurrentMaintenances);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUDescription", FRUDescriptions);
                    ServiceAgentUtils.writeMultiValueString(w, "FRUSerialNumber", FRUSerialNumbers);
                }
                if (sael != null) {
                    int ssid = sael.getSubsystemID();
                    String errorCode = sael.getAIXErrorCode();
                }
                if ((problemDataDescriptors = p.getProblemDataSet()) != null) {
                    Iterator iter = problemDataDescriptors.iterator();
                    int count = problemDataDescriptors.size();
                    String[] files = new String[count];
                    for (int i = 0; i < count; ++i) {
                        ProblemDataDescriptor desc = (ProblemDataDescriptor)iter.next();
                        files[i] = "name=" + desc.getName() + " location=" + desc.getFileLocation() + " type=" + desc.getType() + " isInZip=" + desc.isInZip() + " isCallHomeCandidate=" + desc.isCallHomeCandidate();
                    }
                    ServiceAgentUtils.writeMultiLineString(w, "ExtendedErrorData", files);
                }
                if (p.getDumpLocation() != null) {
                    ServiceAgentUtils.writeString(w, "DumpID", p.getDumpLocation());
                    ServiceAgentUtils.writeString(w, "HMCNameContainingDumpFile", hmcName);
                }
                if (sael != null) {
                    ServiceAgentUtils.writeString(w, "CreatorID", sael.getCreatorID());
                    ServiceAgentUtils.writeString(w, "SymptomString", sael.getSymptomString());
                    ServiceAgentUtils.writeString(w, "ErrorLabel", sael.getErrorLogLabel());
                    ServiceAgentUtils.writeNumeric(w, "ErrorSequence", sael.getSeqNum());
                    ServiceAgentUtils.writeString(w, "OSType", sael.getPartitionOSType());
                    ServiceAgentUtils.writeString(w, "PartitionID", sael.getPartitionID());
                    ServiceAgentUtils.writeString(w, "PartitionName", sael.getPartitionName());
                    ServiceAgentUtils.writeString(w, "HostName", sael.getPartitionHostName());
                } else if (pel != null) {
                    ServiceAgentUtils.writeString(w, "CreatorID", pel.getCreatorID());
                }
                ServiceAgentUtils.writeString(w, "SystemRefCode", p.getSRC());
                ServiceAgentUtils.writeString(w, "PMHNumber", p.getPMH());
                if (p instanceof PIProblem) {
                    PIProblem pip = (PIProblem)p;
                    Set systems = pip.getAssociatedCECSystems();
                    if (systems != null && systems.size() > 0) {
                        int count = systems.size();
                        String[] values = new String[count];
                        Iterator it = systems.iterator();
                        for (int i = 0; i < count; ++i) {
                            system = (PASystem)it.next();
                            values[i] = system.getMachineType() + "-" + system.getMachineModel() + "-" + system.getMachineSerial();
                        }
                        ServiceAgentUtils.writeMultiValueString(w, "FDAdditionalMachine", values);
                    }
                    if ((system = pip.getClusterSystem()) != null) {
                        ServiceAgentUtils.writeString(w, "ClusterMachineTypeModel", system.getMachineType() + "-" + system.getMachineModel());
                        ServiceAgentUtils.writeString(w, "ClusterMachineSerialNumber", system.getMachineSerial());
                    }
                    ServiceAgentUtils.writeString(w, "FederationNetworkID", pip.getSwitchNetworkID());
                    XMLEncodeableArrayList comments = pip.getCeComments();
                    if (comments != null && comments.size() > 0) {
                        int count = comments.size();
                        String[] CEDataNames = new String[count];
                        String[] CEDataTexts = new String[count];
                        long[] CEDataTimestamps = new long[count];
                        for (int i = 0; i < count; ++i) {
                            CeComment comment = (CeComment)comments.get(i);
                            CEDataNames[i] = comment.getCeName();
                            CEDataTexts[i] = comment.getCeComment();
                            CEDataTimestamps[i] = comment.getCeCommentTimeStamp();
                        }
                        ServiceAgentUtils.writeMultiLineString(w, "CEDataName", CEDataNames);
                        ServiceAgentUtils.writeMultiLineString(w, "CEDataText", CEDataTexts);
                        ServiceAgentUtils.writeMultiLineTimestamp(w, "CEDataTimestamp", CEDataTimestamps);
                    }
                    ServiceAgentUtils.writeString(w, "PlatformLogID", pip.getPlatformLogID());
                    ServiceAgentUtils.writeString(w, "SubsystemID", pip.getSubsystemID());
                    ServiceAgentUtils.writeString(w, "EventSeverity", pip.getEventSeverity());
                }
            }
            w.close();
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Done writing file; about to invoke OEM program");
            try {
                Process proc = Runtime.getRuntime().exec("/opt/hsc/bin/callsa -f " + problemDescriptionFile);
                int rc = ServiceAgentUtils.getExitStatus(proc);
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] Exit status from /opt/hsc/bin/callsa = " + rc);
                new File(problemDescriptionFile).delete();
            }
            catch (IOException npioe) {
                Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] IOException occurred while trying to invoke /opt/hsc/bin/callsa: " + npioe);
            }
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "[ServiceAgentUtils] IOException occurred while writing " + problemDescriptionFile + ": " + ioe);
        }
        Trace.trace(TRACE_MASKT, "[ServiceAgentUtils] <- notifyOEM");
        return null;
    }

    private static void writeString(BufferedWriter w, String key, String value) throws IOException {
        if (value != null) {
            w.write(key + startDelim + value + endDelim);
            w.newLine();
        }
    }

    private static void writeNumeric(BufferedWriter w, String key, long value) throws IOException {
        w.write(key + startDelim + value + endDelim);
        w.newLine();
    }

    private static void writeBoolean(BufferedWriter w, String key, boolean value) throws IOException {
        w.write(key + startDelim + (value ? "Yes" : "No") + endDelim);
        w.newLine();
    }

    private static void writeTimestamp(BufferedWriter w, String key, long value) throws IOException {
        if (value != 0L) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
            w.write(key + startDelim + timestampFormatter.format(new Date(value)) + endDelim);
            w.newLine();
        }
    }

    private static void writeMultiLineString(BufferedWriter w, String key, String[] values) throws IOException {
        if (values != null) {
            int i;
            boolean found = false;
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].length() == 0) continue;
                found = true;
                break;
            }
            if (found) {
                w.write(key + startDelim);
                w.newLine();
                for (i = 0; i < values.length; ++i) {
                    String value = values[i];
                    w.write(" " + (value == null ? "" : value.replace(';', '.') + " ") + delim);
                    w.newLine();
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private static void writeMultiLineString(BufferedWriter w, String key, List values) throws IOException {
        if (values != null && values.size() > 0) {
            int count = values.size();
            String[] strings = new String[count];
            Iterator it = values.iterator();
            for (int i = 0; i < count; ++i) {
                strings[i] = (String)it.next();
            }
            ServiceAgentUtils.writeMultiLineString(w, key, strings);
        }
    }

    private static void writeMultiValueString(BufferedWriter w, String key, String[] values) throws IOException {
        if (values != null) {
            int i;
            boolean found = false;
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null || values[i].length() == 0) continue;
                found = true;
                break;
            }
            if (found) {
                w.write(key + startDelim);
                for (i = 0; i < values.length; ++i) {
                    String value = values[i];
                    w.write(" " + (value == null ? "" : value.replace(';', '.') + " ") + delim);
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private static void writeMultiValueBoolean(BufferedWriter w, String key, boolean[] values) throws IOException {
        if (values != null) {
            w.write(key + startDelim);
            for (int i = 0; i < values.length; ++i) {
                boolean value = values[i];
                w.write(" " + (value ? "Yes " : "No ") + delim);
            }
            w.write(" <=;=>");
            w.newLine();
        }
    }

    private static void writeMultiLineTimestamp(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0L) continue;
                found = true;
                break;
            }
            if (found) {
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
                w.write(key + startDelim);
                w.newLine();
                for (int i = 0; i < values.length; ++i) {
                    long value = values[i];
                    w.write(" " + timestampFormatter.format(new Date(value)) + " " + delim);
                    w.newLine();
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private static void writeMultiValueTimestamp(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0L) continue;
                found = true;
                break;
            }
            if (found) {
                SimpleDateFormat timestampFormatter = new SimpleDateFormat(TIMESTAMP_PATTERN);
                w.write(key + startDelim);
                for (int i = 0; i < values.length; ++i) {
                    long value = values[i];
                    w.write(" " + timestampFormatter.format(new Date(value)) + " " + delim);
                }
                w.write(" <=;=>");
                w.newLine();
            }
        }
    }

    private static void writeMultiValueNumeric(BufferedWriter w, String key, long[] values) throws IOException {
        if (values != null) {
            w.write(key + startDelim);
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                w.write(" " + value + " " + delim);
            }
            w.write(" <=;=>");
            w.newLine();
        }
    }

    private static int getExitStatus(Process proc) {
        Trace.trace(TRACE_MASKT, "->getExitStatus()");
        boolean done = false;
        int exitStatus = -1;
        while (!done) {
            try {
                exitStatus = proc.waitFor();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace(TRACE_MASKT, "<-getExitStatus() returning " + exitStatus);
        return exitStatus;
    }

    public static long extractU64(byte[] theArray, int offset, boolean swapBytes) {
        long theValue;
        if (swapBytes) {
            theValue = ((long)theArray[offset + 7] & 0xFFL) << 56;
            theValue = ((long)theArray[offset + 6] & 0xFFL) << 48;
            theValue = ((long)theArray[offset + 5] & 0xFFL) << 40;
            theValue = ((long)theArray[offset + 4] & 0xFFL) << 32;
            theValue = ((long)theArray[offset + 3] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 8;
            theValue += (long)theArray[offset] & 0xFFL;
        } else {
            theValue = ((long)theArray[offset] & 0xFFL) << 56;
            theValue += ((long)theArray[offset + 1] & 0xFFL) << 48;
            theValue += ((long)theArray[offset + 2] & 0xFFL) << 40;
            theValue += ((long)theArray[offset + 3] & 0xFFL) << 32;
            theValue += ((long)theArray[offset + 4] & 0xFFL) << 24;
            theValue += ((long)theArray[offset + 5] & 0xFFL) << 16;
            theValue += ((long)theArray[offset + 6] & 0xFFL) << 8;
            theValue += (long)theArray[offset + 7] & 0xFFL;
        }
        return theValue;
    }

    public static void main(String[] args) {
        Map[] mapArray = ServiceAgentUtils.getPartitionInfo("9119", "590", "02AB33C");
        if (mapArray != null) {
            for (int i = 0; i < mapArray.length; ++i) {
                Map tmpMap = mapArray[i];
                Iterator j = tmpMap.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry e = j.next();
                    System.out.println("key[" + e.getKey() + "] value[" + e.getValue() + "]");
                }
            }
        }
        int rc = ServiceAgentUtils.XmitPM("Xmit_PM_Immediate");
    }

    private static class sectionInfo {
        public int section;
        public int entrySize;
        public int priority;
        public long size;
        public boolean add;

        private sectionInfo() {
        }
    }

    public static class EmailValueObject
    implements Serializable {
        public String EmailAddress;
        public String EmailSetting;
    }
}

